/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.cache.CacheFile;
import org.elasticsearch.index.store.cache.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsConstants;

public class CacheService
extends AbstractLifecycleComponent {
    private static final String SETTINGS_PREFIX = "xpack.searchable.snapshot.cache.";
    public static final Setting<ByteSizeValue> SNAPSHOT_CACHE_SIZE_SETTING = Setting.byteSizeSetting((String)"xpack.searchable.snapshot.cache.size", (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), (ByteSizeValue)new ByteSizeValue(0L, ByteSizeUnit.BYTES), (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SNAPSHOT_CACHE_RANGE_SIZE_SETTING = Setting.byteSizeSetting((String)"xpack.searchable.snapshot.cache.range_size", (ByteSizeValue)new ByteSizeValue(32L, ByteSizeUnit.MB), (ByteSizeValue)new ByteSizeValue(4L, ByteSizeUnit.KB), (ByteSizeValue)new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final Cache<CacheKey, CacheFile> cache;
    private final ByteSizeValue cacheSize;
    private final Runnable cacheCleaner;
    private final ByteSizeValue rangeSize;

    public CacheService(Runnable cacheCleaner, Settings settings) {
        this(cacheCleaner, (ByteSizeValue)SNAPSHOT_CACHE_SIZE_SETTING.get(settings), (ByteSizeValue)SNAPSHOT_CACHE_RANGE_SIZE_SETTING.get(settings));
    }

    public CacheService(Runnable cacheCleaner, ByteSizeValue cacheSize, ByteSizeValue rangeSize) {
        this.cacheSize = Objects.requireNonNull(cacheSize);
        this.cacheCleaner = Objects.requireNonNull(cacheCleaner);
        this.rangeSize = Objects.requireNonNull(rangeSize);
        this.cache = CacheBuilder.builder().setMaximumWeight(cacheSize.getBytes()).weigher((key, entry) -> entry.getLength()).removalListener(notification -> IOUtils.closeWhileHandlingException(() -> ((CacheFile)notification.getValue()).startEviction())).build();
    }

    public static Path getShardCachePath(ShardPath shardPath) {
        return shardPath.getDataPath().resolve("snapshot_cache");
    }

    protected void doStart() {
        this.cacheCleaner.run();
    }

    protected void doStop() {
        this.cache.invalidateAll();
    }

    protected void doClose() {
    }

    private void ensureLifecycleStarted() {
        Lifecycle.State state = this.lifecycleState();
        assert (state != Lifecycle.State.INITIALIZED) : state;
        if (state != Lifecycle.State.STARTED) {
            throw new IllegalStateException("Failed to read data from cache: cache service is not started [" + state + "]");
        }
    }

    public long getCacheSize() {
        return this.cacheSize.getBytes();
    }

    public int getRangeSize() {
        return SearchableSnapshotsConstants.toIntBytes((long)this.rangeSize.getBytes());
    }

    public CacheFile get(CacheKey cacheKey, long fileLength, Path cacheDir) throws Exception {
        this.ensureLifecycleStarted();
        return (CacheFile)this.cache.computeIfAbsent((Object)cacheKey, key -> {
            this.ensureLifecycleStarted();
            String uuid = UUIDs.randomBase64UUID();
            Path path = cacheDir.resolve(uuid);
            assert (Files.notExists(path, new LinkOption[0])) : "cache file already exists " + path;
            return new CacheFile(key.toString(), fileLength, path);
        });
    }

    public void removeFromCache(Predicate<CacheKey> predicate) {
        for (CacheKey cacheKey : this.cache.keys()) {
            if (!predicate.test(cacheKey)) continue;
            this.cache.invalidate((Object)cacheKey);
        }
        this.cache.refresh();
    }
}

