/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.nio.file.Path;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.SearchableSnapshotDirectory;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsConstants;

public class SearchableSnapshotIndexEventListener
implements IndexEventListener {
    public void beforeIndexShardRecovery(IndexShard indexShard, IndexSettings indexSettings) {
        assert (Thread.currentThread().getName().contains("generic"));
        SearchableSnapshotIndexEventListener.ensureSnapshotIsLoaded(indexShard);
        SearchableSnapshotIndexEventListener.associateNewEmptyTranslogWithIndex(indexShard);
    }

    private static void ensureSnapshotIsLoaded(IndexShard indexShard) {
        SearchableSnapshotDirectory directory = SearchableSnapshotDirectory.unwrapDirectory(indexShard.store().directory());
        assert (directory != null);
        boolean success = directory.loadSnapshot(indexShard.recoveryState());
        assert (directory.listAll().length > 0) : "expecting directory listing to be non-empty";
        assert (success || indexShard.routingEntry().recoverySource().getType() == RecoverySource.Type.PEER) : "loading snapshot must not be called twice unless we are retrying a peer recovery";
    }

    private static void associateNewEmptyTranslogWithIndex(IndexShard indexShard) {
        ShardId shardId = indexShard.shardId();
        assert (SearchableSnapshotsConstants.isSearchableSnapshotStore((Settings)indexShard.indexSettings().getSettings())) : "Expected a searchable snapshot shard " + shardId;
        try {
            SegmentInfos segmentInfos = indexShard.store().readLastCommittedSegmentsInfo();
            long localCheckpoint = Long.parseLong((String)segmentInfos.userData.get("local_checkpoint"));
            long primaryTerm = indexShard.getPendingPrimaryTerm();
            String translogUUID = (String)segmentInfos.userData.get("translog_uuid");
            Path translogLocation = indexShard.shardPath().resolveTranslog();
            Translog.createEmptyTranslog((Path)translogLocation, (ShardId)shardId, (long)localCheckpoint, (long)primaryTerm, (String)translogUUID, null);
        }
        catch (Exception e) {
            throw new TranslogException(shardId, "failed to associate a new translog", (Throwable)e);
        }
    }
}

