/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.license.XPackLicenseState;

public class FailShardsOnInvalidLicenseClusterListener
implements LicenseStateListener,
IndexEventListener {
    private static final Logger logger = LogManager.getLogger(FailShardsOnInvalidLicenseClusterListener.class);
    private final XPackLicenseState xPackLicenseState;
    private final RerouteService rerouteService;
    final Set<IndexShard> shardsToFail = new HashSet<IndexShard>();
    private boolean allowed;

    public FailShardsOnInvalidLicenseClusterListener(XPackLicenseState xPackLicenseState, RerouteService rerouteService) {
        this.xPackLicenseState = xPackLicenseState;
        this.rerouteService = rerouteService;
        this.allowed = xPackLicenseState.isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS);
        xPackLicenseState.addListener((LicenseStateListener)this);
    }

    public synchronized void afterIndexShardStarted(IndexShard indexShard) {
        this.shardsToFail.add(indexShard);
        this.failActiveShardsIfNecessary();
    }

    public synchronized void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.shardsToFail.remove(indexShard);
        }
    }

    public synchronized void licenseStateChanged() {
        boolean allowed = this.xPackLicenseState.isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS);
        if (allowed && !this.allowed) {
            this.rerouteService.reroute("reroute after license activation", Priority.NORMAL, (ActionListener)new ActionListener<ClusterState>(){

                public void onResponse(ClusterState clusterState) {
                    logger.trace("successful reroute after license activation");
                }

                public void onFailure(Exception e) {
                    logger.debug("unsuccessful reroute after license activation");
                }
            });
        }
        this.allowed = allowed;
        this.failActiveShardsIfNecessary();
    }

    private void failActiveShardsIfNecessary() {
        assert (Thread.holdsLock(this));
        if (!this.allowed) {
            for (IndexShard indexShard : this.shardsToFail) {
                try {
                    indexShard.failShard("invalid license", null);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("Could not close shard {} due to invalid license", (Object)indexShard.shardId()), (Throwable)e);
                }
            }
            this.shardsToFail.clear();
        }
    }
}

