/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.cache;

import java.util.Objects;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.snapshots.SnapshotId;

public class CacheKey {
    private final SnapshotId snapshotId;
    private final IndexId indexId;
    private final ShardId shardId;
    private final String fileName;

    public CacheKey(SnapshotId snapshotId, IndexId indexId, ShardId shardId, String fileName) {
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.indexId = Objects.requireNonNull(indexId);
        this.shardId = Objects.requireNonNull(shardId);
        this.fileName = Objects.requireNonNull(fileName);
    }

    SnapshotId getSnapshotId() {
        return this.snapshotId;
    }

    IndexId getIndexId() {
        return this.indexId;
    }

    ShardId getShardId() {
        return this.shardId;
    }

    String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.snapshotId, cacheKey.snapshotId) && Objects.equals(this.indexId, cacheKey.indexId) && Objects.equals(this.shardId, cacheKey.shardId) && Objects.equals(this.fileName, cacheKey.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotId, this.indexId, this.shardId, this.fileName);
    }

    public String toString() {
        return "[snapshotId=" + this.snapshotId + ", indexId=" + this.indexId + ", shardId=" + this.shardId + ", fileName='" + this.fileName + "']";
    }

    public boolean belongsTo(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        return Objects.equals(this.snapshotId, snapshotId) && Objects.equals(this.indexId, indexId) && Objects.equals(this.shardId, shardId);
    }
}

