/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.flattened;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.flattened.FlattenedFeatureSetUsage;

public class FlattenedFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;

    @Inject
    public FlattenedFeatureSet(XPackLicenseState licenseState, ClusterService clusterService) {
        this.licenseState = licenseState;
        this.clusterService = clusterService;
    }

    public String name() {
        return "flattened";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.FLATTENED);
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        int fieldCount = 0;
        if (this.available() && this.enabled() && this.clusterService.state() != null) {
            for (IndexMetadata indexMetadata : this.clusterService.state().metadata()) {
                Map mappings;
                MappingMetadata mappingMetadata = indexMetadata.mapping();
                if (mappingMetadata == null || !(mappings = mappingMetadata.getSourceAsMap()).containsKey("properties")) continue;
                Map fieldMappings = (Map)mappings.get("properties");
                for (Map fieldMapping : fieldMappings.values()) {
                    String fieldType = (String)fieldMapping.get("type");
                    if (fieldType == null || !fieldType.equals("flattened")) continue;
                    ++fieldCount;
                }
            }
        }
        listener.onResponse((Object)new FlattenedFeatureSetUsage(this.available(), fieldCount));
    }
}

