/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.slm.SLMFeatureSetUsage;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;

public class SLMFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private ClusterService clusterService;

    @Inject
    public SLMFeatureSet(@Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.clusterService = clusterService;
        this.licenseState = licenseState;
    }

    public String name() {
        return "slm";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isAllowed(XPackLicenseState.Feature.ILM);
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        boolean available = this.licenseState.isAllowed(XPackLicenseState.Feature.ILM);
        SnapshotLifecycleMetadata slmMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        SLMFeatureSetUsage usage = new SLMFeatureSetUsage(available, slmMeta == null ? null : slmMeta.getStats());
        listener.onResponse((Object)usage);
    }
}

