/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GetPipelineResponse
extends ActionResponse
implements ToXContentObject {
    private final Map<String, BytesReference> pipelines;

    public GetPipelineResponse(Map<String, BytesReference> pipelines) {
        this.pipelines = pipelines;
    }

    public GetPipelineResponse(StreamInput in) throws IOException {
        super(in);
        this.pipelines = in.readMap(StreamInput::readString, StreamInput::readBytesReference);
    }

    public Map<String, BytesReference> pipelines() {
        return this.pipelines;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.pipelines, StreamOutput::writeString, StreamOutput::writeBytesReference);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, BytesReference> entry : this.pipelines.entrySet()) {
            builder.rawField(entry.getKey(), (InputStream)entry.getValue().streamInput());
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetPipelineResponse that = (GetPipelineResponse)((Object)o);
        return Objects.equals(this.pipelines, that.pipelines);
    }

    public int hashCode() {
        return Objects.hash(this.pipelines);
    }
}

