/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.enrich.EnrichPolicyReindexPipeline;
import org.elasticsearch.xpack.enrich.ExecuteEnrichPolicyTask;

public class EnrichPolicyRunner
implements Runnable {
    private static final Logger logger = LogManager.getLogger(EnrichPolicyRunner.class);
    static final String ENRICH_POLICY_NAME_FIELD_NAME = "enrich_policy_name";
    static final String ENRICH_POLICY_TYPE_FIELD_NAME = "enrich_policy_type";
    static final String ENRICH_MATCH_FIELD_NAME = "enrich_match_field";
    static final String ENRICH_README_FIELD_NAME = "enrich_readme";
    static final String ENRICH_INDEX_README_TEXT = "This index is managed by Elasticsearch and should not be modified in any way.";
    private final String policyName;
    private final EnrichPolicy policy;
    private final ExecuteEnrichPolicyTask task;
    private final ActionListener<ExecuteEnrichPolicyStatus> listener;
    private final ClusterService clusterService;
    private final Client client;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final LongSupplier nowSupplier;
    private final int fetchSize;
    private final int maxForceMergeAttempts;

    EnrichPolicyRunner(String policyName, EnrichPolicy policy, ExecuteEnrichPolicyTask task, ActionListener<ExecuteEnrichPolicyStatus> listener, ClusterService clusterService, Client client, IndexNameExpressionResolver indexNameExpressionResolver, LongSupplier nowSupplier, int fetchSize, int maxForceMergeAttempts) {
        this.policyName = policyName;
        this.policy = policy;
        this.task = task;
        this.listener = listener;
        this.clusterService = clusterService;
        this.client = client;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.nowSupplier = nowSupplier;
        this.fetchSize = fetchSize;
        this.maxForceMergeAttempts = maxForceMergeAttempts;
    }

    @Override
    public void run() {
        logger.info("Policy [{}]: Running enrich policy", (Object)this.policyName);
        this.task.setStatus(new ExecuteEnrichPolicyStatus("RUNNING"));
        String[] sourceIndices = this.policy.getIndices().toArray(new String[0]);
        logger.debug("Policy [{}]: Checking source indices [{}]", (Object)this.policyName, (Object)sourceIndices);
        GetIndexRequest getIndexRequest = (GetIndexRequest)new GetIndexRequest().indices(sourceIndices);
        this.client.admin().indices().getIndex(getIndexRequest, (ActionListener)new ActionListener<GetIndexResponse>(){

            public void onResponse(GetIndexResponse getIndexResponse) {
                EnrichPolicyRunner.this.validateMappings(getIndexResponse);
                EnrichPolicyRunner.this.prepareAndCreateEnrichIndex();
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private Map<String, Object> getMappings(GetIndexResponse getIndexResponse, String sourceIndexName) {
        ImmutableOpenMap mappings = getIndexResponse.mappings();
        ImmutableOpenMap indexMapping = (ImmutableOpenMap)mappings.get((Object)sourceIndexName);
        if (indexMapping.keys().size() == 0) {
            throw new ElasticsearchException("Enrich policy execution for [{}] failed. No mapping available on source [{}] included in [{}]", new Object[]{this.policyName, sourceIndexName, this.policy.getIndices()});
        }
        assert (indexMapping.keys().size() == 1) : "Expecting only one type per index";
        MappingMetadata typeMapping = (MappingMetadata)((ObjectObjectCursor)indexMapping.iterator().next()).value;
        return typeMapping.sourceAsMap();
    }

    private void validateMappings(GetIndexResponse getIndexResponse) {
        String[] sourceIndices = getIndexResponse.getIndices();
        logger.debug("Policy [{}]: Validating [{}] source mappings", (Object)this.policyName, (Object)sourceIndices);
        for (String sourceIndex : sourceIndices) {
            Map<String, Object> mapping = this.getMappings(getIndexResponse, sourceIndex);
            EnrichPolicyRunner.validateMappings(this.policyName, this.policy, sourceIndex, mapping);
        }
    }

    static void validateMappings(String policyName, EnrichPolicy policy, String sourceIndex, Map<String, Object> mapping) {
        if (mapping.get("properties") == null) {
            throw new ElasticsearchException("Enrich policy execution for [{}] failed. Could not read mapping for source [{}] included by pattern [{}]", new Object[]{policyName, sourceIndex, policy.getIndices()});
        }
        try {
            EnrichPolicyRunner.validateField(mapping, policy.getMatchField(), true);
            for (String valueFieldName : policy.getEnrichFields()) {
                EnrichPolicyRunner.validateField(mapping, valueFieldName, false);
            }
        }
        catch (ElasticsearchException e) {
            throw new ElasticsearchException("Enrich policy execution for [{}] failed while validating field mappings for index [{}]", (Throwable)e, new Object[]{policyName, sourceIndex});
        }
    }

    private static void validateField(Map<?, ?> properties, String fieldName, boolean fieldRequired) {
        assert (!Strings.isEmpty((CharSequence)fieldName)) : "Field name cannot be null or empty";
        String[] fieldParts = fieldName.split("\\.");
        StringBuilder parent = new StringBuilder();
        Map currentField = properties;
        boolean onRoot = true;
        for (String fieldPart : fieldParts) {
            Object type = currentField.get("type");
            if (type != null && !"object".equals(type)) {
                throw new ElasticsearchException("Could not traverse mapping to field [{}]. The [{}] field must be regular object but was [{}].", new Object[]{fieldName, onRoot ? "root" : parent.toString(), type});
            }
            Map currentProperties = (Map)currentField.get("properties");
            if (currentProperties == null) {
                if (fieldRequired) {
                    throw new ElasticsearchException("Could not traverse mapping to field [{}]. Expected the [{}] field to have sub fields but none were configured.", new Object[]{fieldName, onRoot ? "root" : parent.toString()});
                }
                return;
            }
            currentField = (Map)currentProperties.get(fieldPart);
            if (currentField == null) {
                if (fieldRequired) {
                    throw new ElasticsearchException("Could not traverse mapping to field [{}]. Could not find the [{}] field under [{}]", new Object[]{fieldName, fieldPart, onRoot ? "root" : parent.toString()});
                }
                return;
            }
            if (onRoot) {
                onRoot = false;
            } else {
                parent.append(".");
            }
            parent.append(fieldPart);
        }
    }

    private XContentBuilder resolveEnrichMapping(EnrichPolicy policy) {
        CheckedFunction matchFieldMapping;
        if ("match".equals(policy.getType())) {
            matchFieldMapping = builder -> builder.field("type", "keyword").field("doc_values", false);
        } else if ("geo_match".equals(policy.getType())) {
            matchFieldMapping = builder -> builder.field("type", "geo_shape");
        } else {
            throw new ElasticsearchException("Unrecognized enrich policy type [{}]", new Object[]{policy.getType()});
        }
        try {
            XContentBuilder builder2 = JsonXContent.contentBuilder();
            builder2.startObject();
            builder2.startObject("_doc");
            builder2.field("dynamic", false);
            builder2.startObject("_source");
            builder2.field("enabled", true);
            builder2.endObject();
            builder2.startObject("properties");
            builder2.startObject(policy.getMatchField());
            matchFieldMapping.apply((Object)builder2);
            builder2.endObject();
            builder2.endObject();
            builder2.startObject("_meta");
            builder2.field(ENRICH_README_FIELD_NAME, ENRICH_INDEX_README_TEXT);
            builder2.field(ENRICH_POLICY_NAME_FIELD_NAME, this.policyName);
            builder2.field(ENRICH_MATCH_FIELD_NAME, policy.getMatchField());
            builder2.field(ENRICH_POLICY_TYPE_FIELD_NAME, policy.getType());
            builder2.endObject();
            builder2.endObject();
            builder2.endObject();
            return builder2;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Could not render enrich mapping", ioe);
        }
    }

    private void prepareAndCreateEnrichIndex() {
        long nowTimestamp = this.nowSupplier.getAsLong();
        final String enrichIndexName = EnrichPolicy.getBaseName((String)this.policyName) + "-" + nowTimestamp;
        Settings enrichIndexSettings = Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.refresh_interval", -1).put("index.warmer.enabled", false).build();
        CreateIndexRequest createEnrichIndexRequest = new CreateIndexRequest(enrichIndexName, enrichIndexSettings);
        createEnrichIndexRequest.mapping("_doc", this.resolveEnrichMapping(this.policy));
        logger.debug("Policy [{}]: Creating new enrich index [{}]", (Object)this.policyName, (Object)enrichIndexName);
        this.enrichOriginClient().admin().indices().create(createEnrichIndexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(){

            public void onResponse(CreateIndexResponse createIndexResponse) {
                EnrichPolicyRunner.this.prepareReindexOperation(enrichIndexName);
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private void prepareReindexOperation(final String destinationIndexName) {
        if (!EnrichPolicyReindexPipeline.exists(this.clusterService.state())) {
            EnrichPolicyReindexPipeline.create(this.enrichOriginClient(), new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    EnrichPolicyRunner.this.transferDataToEnrichIndex(destinationIndexName);
                }

                public void onFailure(Exception e) {
                    EnrichPolicyRunner.this.listener.onFailure(e);
                }
            });
        } else {
            this.transferDataToEnrichIndex(destinationIndexName);
        }
    }

    private void transferDataToEnrichIndex(final String destinationIndexName) {
        logger.debug("Policy [{}]: Transferring source data to new enrich index [{}]", (Object)this.policyName, (Object)destinationIndexName);
        HashSet<String> retainFields = new HashSet<String>();
        retainFields.add(this.policy.getMatchField());
        retainFields.addAll(this.policy.getEnrichFields());
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(this.fetchSize);
        searchSourceBuilder.fetchSource(retainFields.toArray(new String[0]), new String[0]);
        if (this.policy.getQuery() != null) {
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((BytesReference)this.policy.getQuery().getQuery()));
        }
        ReindexRequest reindexRequest = new ReindexRequest().setDestIndex(destinationIndexName).setSourceIndices(this.policy.getIndices().toArray(new String[0]));
        reindexRequest.getSearchRequest().source(searchSourceBuilder);
        reindexRequest.getDestination().source((BytesReference)new BytesArray(new byte[0]), XContentType.SMILE);
        reindexRequest.getDestination().routing("discard");
        reindexRequest.getDestination().setPipeline(EnrichPolicyReindexPipeline.pipelineName());
        this.client.execute((ActionType)ReindexAction.INSTANCE, (ActionRequest)reindexRequest, (ActionListener)new ContextPreservingActionListener(this.client.threadPool().getThreadContext().newRestorableContext(false), (ActionListener)new ActionListener<BulkByScrollResponse>(){

            public void onResponse(BulkByScrollResponse bulkByScrollResponse) {
                if (bulkByScrollResponse.getBulkFailures().size() > 0) {
                    logger.warn("Policy [{}]: encountered [{}] bulk failures. Turn on DEBUG logging for details.", (Object)EnrichPolicyRunner.this.policyName, (Object)bulkByScrollResponse.getBulkFailures().size());
                    if (logger.isDebugEnabled()) {
                        for (BulkItemResponse.Failure failure : bulkByScrollResponse.getBulkFailures()) {
                            logger.debug((Message)new ParameterizedMessage("Policy [{}]: bulk index failed for index [{}], id [{}]", new Object[]{EnrichPolicyRunner.this.policyName, failure.getIndex(), failure.getId()}), (Throwable)failure.getCause());
                        }
                    }
                    EnrichPolicyRunner.this.listener.onFailure((Exception)new ElasticsearchException("Encountered bulk failures during reindex process", new Object[0]));
                } else if (bulkByScrollResponse.getSearchFailures().size() > 0) {
                    logger.warn("Policy [{}]: encountered [{}] search failures. Turn on DEBUG logging for details.", (Object)EnrichPolicyRunner.this.policyName, (Object)bulkByScrollResponse.getSearchFailures().size());
                    if (logger.isDebugEnabled()) {
                        for (ScrollableHitSource.SearchFailure failure : bulkByScrollResponse.getSearchFailures()) {
                            logger.debug((Message)new ParameterizedMessage("Policy [{}]: search failed for index [{}], shard [{}] on node [{}]", new Object[]{EnrichPolicyRunner.this.policyName, failure.getIndex(), failure.getShardId(), failure.getNodeId()}), failure.getReason());
                        }
                    }
                    EnrichPolicyRunner.this.listener.onFailure((Exception)new ElasticsearchException("Encountered search failures during reindex process", new Object[0]));
                } else {
                    logger.info("Policy [{}]: Transferred [{}] documents to enrich index [{}]", (Object)EnrichPolicyRunner.this.policyName, (Object)bulkByScrollResponse.getCreated(), (Object)destinationIndexName);
                    EnrichPolicyRunner.this.forceMergeEnrichIndex(destinationIndexName, 1);
                }
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        }));
    }

    private void forceMergeEnrichIndex(final String destinationIndexName, final int attempt) {
        logger.debug("Policy [{}]: Force merging newly created enrich index [{}] (Attempt {}/{})", (Object)this.policyName, (Object)destinationIndexName, (Object)attempt, (Object)this.maxForceMergeAttempts);
        this.enrichOriginClient().admin().indices().forceMerge(new ForceMergeRequest(new String[]{destinationIndexName}).maxNumSegments(1), (ActionListener)new ActionListener<ForceMergeResponse>(){

            public void onResponse(ForceMergeResponse forceMergeResponse) {
                EnrichPolicyRunner.this.refreshEnrichIndex(destinationIndexName, attempt);
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private void refreshEnrichIndex(final String destinationIndexName, final int attempt) {
        logger.debug("Policy [{}]: Refreshing enrich index [{}]", (Object)this.policyName, (Object)destinationIndexName);
        this.enrichOriginClient().admin().indices().refresh(new RefreshRequest(new String[]{destinationIndexName}), (ActionListener)new ActionListener<RefreshResponse>(){

            public void onResponse(RefreshResponse refreshResponse) {
                EnrichPolicyRunner.this.ensureSingleSegment(destinationIndexName, attempt);
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    protected void ensureSingleSegment(final String destinationIndexName, final int attempt) {
        this.enrichOriginClient().admin().indices().segments(new IndicesSegmentsRequest(new String[]{destinationIndexName}), (ActionListener)new ActionListener<IndicesSegmentResponse>(){

            public void onResponse(IndicesSegmentResponse indicesSegmentResponse) {
                IndexSegments indexSegments = (IndexSegments)indicesSegmentResponse.getIndices().get(destinationIndexName);
                if (indexSegments == null) {
                    throw new ElasticsearchException("Could not locate segment information for newly created index [{}]", new Object[]{destinationIndexName});
                }
                Map indexShards = indexSegments.getShards();
                assert (indexShards.size() == 1) : "Expected enrich index to contain only one shard";
                ShardSegments[] shardSegments = ((IndexShardSegments)indexShards.get(0)).getShards();
                assert (shardSegments.length == 1) : "Expected enrich index to contain no replicas at this point";
                ShardSegments primarySegments = shardSegments[0];
                if (primarySegments.getSegments().size() > 1) {
                    int nextAttempt = attempt + 1;
                    if (nextAttempt > EnrichPolicyRunner.this.maxForceMergeAttempts) {
                        EnrichPolicyRunner.this.listener.onFailure((Exception)new ElasticsearchException("Force merging index [{}] attempted [{}] times but did not result in one segment.", new Object[]{destinationIndexName, attempt, EnrichPolicyRunner.this.maxForceMergeAttempts}));
                    } else {
                        logger.debug("Policy [{}]: Force merge result contains more than one segment [{}], retrying (attempt {}/{})", (Object)EnrichPolicyRunner.this.policyName, (Object)primarySegments.getSegments().size(), (Object)nextAttempt, (Object)EnrichPolicyRunner.this.maxForceMergeAttempts);
                        EnrichPolicyRunner.this.forceMergeEnrichIndex(destinationIndexName, nextAttempt);
                    }
                } else {
                    EnrichPolicyRunner.this.setIndexReadOnly(destinationIndexName);
                }
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private void setIndexReadOnly(final String destinationIndexName) {
        logger.debug("Policy [{}]: Setting new enrich index [{}] to be read only", (Object)this.policyName, (Object)destinationIndexName);
        UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{destinationIndexName}).setPreserveExisting(true).settings(Settings.builder().put("index.auto_expand_replicas", "0-all").put("index.blocks.write", "true"));
        this.enrichOriginClient().admin().indices().updateSettings(request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                EnrichPolicyRunner.this.waitForIndexGreen(destinationIndexName);
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private void waitForIndexGreen(final String destinationIndexName) {
        ClusterHealthRequest request = new ClusterHealthRequest(new String[]{destinationIndexName}).waitForGreenStatus();
        this.enrichOriginClient().admin().cluster().health(request, (ActionListener)new ActionListener<ClusterHealthResponse>(){

            public void onResponse(ClusterHealthResponse clusterHealthResponse) {
                EnrichPolicyRunner.this.updateEnrichPolicyAlias(destinationIndexName);
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private void updateEnrichPolicyAlias(String destinationIndexName) {
        String enrichIndexBase = EnrichPolicy.getBaseName((String)this.policyName);
        logger.debug("Policy [{}]: Promoting new enrich index [{}] to alias [{}]", (Object)this.policyName, (Object)destinationIndexName, (Object)enrichIndexBase);
        GetAliasesRequest aliasRequest = new GetAliasesRequest(new String[]{enrichIndexBase});
        ClusterState clusterState = this.clusterService.state();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(clusterState, (IndicesRequest)aliasRequest);
        ImmutableOpenMap aliases = clusterState.metadata().findAliases((AliasesRequest)aliasRequest, concreteIndices);
        IndicesAliasesRequest aliasToggleRequest = new IndicesAliasesRequest();
        String[] indices = (String[])aliases.keys().toArray(String.class);
        if (indices.length > 0) {
            aliasToggleRequest.addAliasAction(IndicesAliasesRequest.AliasActions.remove().indices(indices).alias(enrichIndexBase));
        }
        aliasToggleRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(destinationIndexName).alias(enrichIndexBase));
        this.enrichOriginClient().admin().indices().aliases(aliasToggleRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                logger.info("Policy [{}]: Policy execution complete", (Object)EnrichPolicyRunner.this.policyName);
                ExecuteEnrichPolicyStatus completeStatus = new ExecuteEnrichPolicyStatus("COMPLETE");
                EnrichPolicyRunner.this.task.setStatus(completeStatus);
                EnrichPolicyRunner.this.listener.onResponse((Object)completeStatus);
            }

            public void onFailure(Exception e) {
                EnrichPolicyRunner.this.listener.onFailure(e);
            }
        });
    }

    private Client enrichOriginClient() {
        return new OriginSettingClient(this.client, "enrich");
    }
}

