/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.nio.FlushOperation;
import org.elasticsearch.nio.Page;

public class SSLOutboundBuffer
implements AutoCloseable {
    private final ArrayDeque<Page> pages = new ArrayDeque();
    private final IntFunction<Page> pageSupplier;
    private Page currentPage;

    SSLOutboundBuffer(IntFunction<Page> pageSupplier) {
        this.pageSupplier = pageSupplier;
    }

    void incrementEncryptedBytes(int encryptedBytesProduced) {
        if (encryptedBytesProduced != 0) {
            this.currentPage.byteBuffer().limit(encryptedBytesProduced);
            this.pages.addLast(this.currentPage);
        } else if (this.currentPage != null) {
            this.currentPage.close();
        }
        this.currentPage = null;
    }

    ByteBuffer nextWriteBuffer(int networkBufferSize) {
        Page newPage;
        if (this.currentPage != null) {
            this.currentPage.close();
        }
        this.currentPage = newPage = this.pageSupplier.apply(networkBufferSize);
        return newPage.byteBuffer().duplicate();
    }

    FlushOperation buildNetworkFlushOperation() {
        return this.buildNetworkFlushOperation((r, e) -> {});
    }

    FlushOperation buildNetworkFlushOperation(BiConsumer<Void, Exception> listener) {
        int pageCount = this.pages.size();
        ByteBuffer[] byteBuffers = new ByteBuffer[pageCount];
        Page[] pagesToClose = new Page[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            Page page;
            pagesToClose[i] = page = this.pages.removeFirst();
            byteBuffers[i] = page.byteBuffer();
        }
        return new FlushOperation(byteBuffers, (r, e) -> {
            IOUtils.closeWhileHandlingException((Closeable[])pagesToClose);
            listener.accept((Void)r, (Exception)e);
        });
    }

    boolean hasEncryptedBytesToFlush() {
        return !this.pages.isEmpty();
    }

    @Override
    public void close() {
        IOUtils.closeWhileHandlingException((Closeable)this.currentPage);
        IOUtils.closeWhileHandlingException(this.pages);
    }
}

