/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.rolemapping;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequestBuilder;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingResponse;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestDeleteRoleMappingAction
extends SecurityBaseRestHandler {
    public RestDeleteRoleMappingAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.DELETE, "/_security/role_mapping/{name}", RestRequest.Method.DELETE, "/_xpack/security/role_mapping/{name}"));
    }

    public String getName() {
        return "security_delete_role_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String name = request.param("name");
        String refresh = request.param("refresh");
        return channel -> ((DeleteRoleMappingRequestBuilder)new SecurityClient((ElasticsearchClient)client).prepareDeleteRoleMapping(name).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<DeleteRoleMappingResponse>(channel){

            public RestResponse buildResponse(DeleteRoleMappingResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(response.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND, builder.startObject().field("found", response.isFound()).endObject());
            }
        });
    }
}

