/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.action.GrantApiKeyAction;
import org.elasticsearch.xpack.core.security.action.GrantApiKeyRequest;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

public final class RestGrantApiKeyAction
extends ApiKeyBaseRestHandler
implements RestRequestFilter {
    static final ObjectParser<GrantApiKeyRequest, Void> PARSER = new ObjectParser("grant_api_key_request", GrantApiKeyRequest::new);
    private static final Set<String> FILTERED_FIELDS;

    private static SecureString getSecureString(XContentParser parser) throws IOException {
        return new SecureString(Arrays.copyOfRange(parser.textCharacters(), parser.textOffset(), parser.textOffset() + parser.textLength()));
    }

    public RestGrantApiKeyAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_security/api_key/grant"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key/grant")));
    }

    public String getName() {
        return "xpack_security_grant_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String refresh = request.param("refresh");
        try (XContentParser parser = request.contentParser();){
            GrantApiKeyRequest grantRequest = (GrantApiKeyRequest)PARSER.parse(parser, null);
            if (refresh != null) {
                grantRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)refresh));
            }
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute((ActionType)GrantApiKeyAction.INSTANCE, (ActionRequest)grantRequest, ActionListener.delegateResponse((ActionListener)new RestToXContentListener(channel), (listener, ex) -> {
                RestStatus status = ExceptionsHelper.status((Throwable)ex);
                if (status == RestStatus.UNAUTHORIZED) {
                    listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Failed to authenticate api key grant", RestStatus.FORBIDDEN, (Throwable)ex, new Object[0])));
                } else {
                    listener.onFailure(ex);
                }
            }));
            return restChannelConsumer;
        }
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        PARSER.declareString((req, str) -> req.getGrant().setType(str), new ParseField("grant_type", new String[0]));
        PARSER.declareString((req, str) -> req.getGrant().setUsername(str), new ParseField("username", new String[0]));
        PARSER.declareField((req, secStr) -> req.getGrant().setPassword(secStr), RestGrantApiKeyAction::getSecureString, new ParseField("password", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField((req, secStr) -> req.getGrant().setAccessToken(secStr), RestGrantApiKeyAction::getSecureString, new ParseField("access_token", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareObject((req, api) -> req.setApiKeyRequest(api), (parser, ignore) -> CreateApiKeyRequestBuilder.parse((XContentParser)parser), new ParseField("api_key", new String[0]));
        FILTERED_FIELDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"password", "access_token"}));
    }
}

