/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.Set;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheAction;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheRequest;
import org.elasticsearch.xpack.core.security.action.privilege.ClearPrivilegesCacheResponse;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativePrivilegeStore {
    public static final Setting<Integer> CACHE_MAX_APPLICATIONS_SETTING = Setting.intSetting((String)"xpack.security.authz.store.privileges.cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.authz.store.privileges.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)24L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Collector<Tuple<String, String>, ?, Map<String, List<String>>> TUPLES_TO_MAP = Collectors.toMap(Tuple::v1, t -> CollectionUtils.newSingletonArrayList((Object)((String)t.v2())), (a, b) -> {
        a.addAll(b);
        return a;
    });
    private static final Logger logger = LogManager.getLogger(NativePrivilegeStore.class);
    private final Settings settings;
    private final Client client;
    private final SecurityIndexManager securityIndexManager;
    private final Cache<String, java.util.Set<ApplicationPrivilegeDescriptor>> descriptorsCache;
    private final Cache<java.util.Set<String>, java.util.Set<String>> applicationNamesCache;
    private final AtomicLong numInvalidation = new AtomicLong();
    private final ReadWriteLock invalidationLock = new ReentrantReadWriteLock();
    private final ReleasableLock invalidationReadLock = new ReleasableLock(this.invalidationLock.readLock());
    private final ReleasableLock invalidationWriteLock = new ReleasableLock(this.invalidationLock.writeLock());

    public NativePrivilegeStore(Settings settings, Client client, SecurityIndexManager securityIndexManager) {
        this.settings = settings;
        this.client = client;
        this.securityIndexManager = securityIndexManager;
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        if (ttl.getNanos() > 0L) {
            int cacheSize = (Integer)CACHE_MAX_APPLICATIONS_SETTING.get(settings);
            this.descriptorsCache = CacheBuilder.builder().setMaximumWeight((long)cacheSize).weigher((k, v) -> v.size()).setExpireAfterWrite(ttl).build();
            this.applicationNamesCache = CacheBuilder.builder().setMaximumWeight((long)cacheSize).weigher((k, v) -> k.size() + v.size()).setExpireAfterWrite(ttl).build();
        } else {
            this.descriptorsCache = null;
            this.applicationNamesCache = null;
        }
        assert (this.descriptorsCache == null && this.applicationNamesCache == null || this.descriptorsCache != null && this.applicationNamesCache != null) : "descriptor and application names cache must be enabled or disabled together";
    }

    public void getPrivileges(Collection<String> applications, Collection<String> names, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        java.util.Set concreteApplicationNames;
        java.util.Set applicationNamesCacheKey = NativePrivilegeStore.isEmpty(applications) || applications.contains("*") ? Set.of((Object)"*") : Set.copyOf(applications);
        java.util.Set set = concreteApplicationNames = this.applicationNamesCache == null ? null : (java.util.Set)this.applicationNamesCache.get((Object)applicationNamesCacheKey);
        if (concreteApplicationNames != null && concreteApplicationNames.isEmpty()) {
            logger.debug("returning empty application privileges for [{}] as application names result in empty list", (Object)applicationNamesCacheKey);
            listener.onResponse(Collections.emptySet());
        } else {
            java.util.Set<ApplicationPrivilegeDescriptor> cachedDescriptors = this.cachedDescriptorsForApplicationNames(concreteApplicationNames != null ? concreteApplicationNames : applicationNamesCacheKey);
            if (cachedDescriptors != null) {
                logger.debug("All application privileges for [{}] found in cache", (Object)applicationNamesCacheKey);
                listener.onResponse(this.filterDescriptorsForPrivilegeNames(cachedDescriptors, names));
            } else {
                long invalidationCounter = this.numInvalidation.get();
                logger.debug("Fetching application privilege documents for: {}", (Object)applicationNamesCacheKey);
                this.innerGetPrivileges(applicationNamesCacheKey, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(fetchedDescriptors -> {
                    Map<String, java.util.Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors = fetchedDescriptors.stream().collect(Collectors.groupingBy(ApplicationPrivilegeDescriptor::getApplication, Collectors.toSet()));
                    if (this.descriptorsCache != null) {
                        try (ReleasableLock ignored = this.invalidationReadLock.acquire();){
                            if (invalidationCounter == this.numInvalidation.get()) {
                                this.cacheFetchedDescriptors(applicationNamesCacheKey, mapOfFetchedDescriptors);
                            }
                        }
                    }
                    listener.onResponse(this.filterDescriptorsForPrivilegeNames((Collection<ApplicationPrivilegeDescriptor>)fetchedDescriptors, names));
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        }
    }

    private void innerGetPrivileges(Collection<String> applications, ActionListener<Collection<ApplicationPrivilegeDescriptor>> listener) {
        assert (applications != null && applications.size() > 0) : "Application names are required (found " + applications + ")";
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason()));
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder typeQuery = QueryBuilders.termQuery((String)ApplicationPrivilegeDescriptor.Fields.TYPE.getPreferredName(), (String)"application-privilege");
                BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)typeQuery).filter(this.getApplicationNameQuery(applications));
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    logger.trace(() -> NativePrivilegeStore.lambda$innerGetPrivileges$5(applications, (QueryBuilder)query));
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> this.buildPrivilege(hit.getId(), hit.getSourceRef()));
                }
            });
        }
    }

    private QueryBuilder getApplicationNameQuery(Collection<String> applications) {
        TermsQueryBuilder termsQuery;
        if (applications.contains("*")) {
            return QueryBuilders.existsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName());
        }
        ArrayList<String> rawNames = new ArrayList<String>(applications.size());
        ArrayList<String> wildcardNames = new ArrayList<String>(applications.size());
        for (String name : applications) {
            if (name.endsWith("*")) {
                wildcardNames.add(name);
                continue;
            }
            rawNames.add(name);
        }
        assert (!rawNames.isEmpty() || !wildcardNames.isEmpty());
        TermsQueryBuilder termsQueryBuilder = termsQuery = rawNames.isEmpty() ? null : QueryBuilders.termsQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), rawNames);
        if (wildcardNames.isEmpty()) {
            return termsQuery;
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (termsQuery != null) {
            boolQuery.should((QueryBuilder)termsQuery);
        }
        for (String wildcard : wildcardNames) {
            String prefix = wildcard.substring(0, wildcard.length() - 1);
            boolQuery.should((QueryBuilder)QueryBuilders.prefixQuery((String)ApplicationPrivilegeDescriptor.Fields.APPLICATION.getPreferredName(), (String)prefix));
        }
        boolQuery.minimumShouldMatch(1);
        return boolQuery;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ApplicationPrivilegeDescriptor buildPrivilege(String docId, BytesReference source) {
        logger.trace("Building privilege from [{}] [{}]", (Object)docId, (Object)(source == null ? "<<null>>" : source.utf8ToString()));
        if (source == null) {
            return null;
        }
        Tuple<String, String> name = NativePrivilegeStore.nameFromDocId(docId);
        try (StreamInput input = source.streamInput();){
            ApplicationPrivilegeDescriptor applicationPrivilegeDescriptor;
            block17: {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)input);
                try {
                    ApplicationPrivilegeDescriptor privilege = ApplicationPrivilegeDescriptor.parse((XContentParser)parser, null, null, (boolean)true);
                    assert (privilege.getApplication().equals(name.v1())) : "Incorrect application name for privilege. Expected [" + (String)name.v1() + "] but was " + privilege.getApplication();
                    assert (privilege.getName().equals(name.v2())) : "Incorrect name for application privilege. Expected [" + (String)name.v2() + "] but was " + privilege.getName();
                    applicationPrivilegeDescriptor = privilege;
                    if (parser == null) break block17;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return applicationPrivilegeDescriptor;
        }
        catch (IOException | XContentParseException e) {
            logger.error((Message)new ParameterizedMessage("cannot parse application privilege [{}]", name), e);
            return null;
        }
    }

    private java.util.Set<ApplicationPrivilegeDescriptor> cachedDescriptorsForApplicationNames(java.util.Set<String> applicationNames) {
        if (this.descriptorsCache == null) {
            return null;
        }
        HashSet cachedDescriptors = new HashSet();
        for (String applicationName : applicationNames) {
            if (applicationName.endsWith("*")) {
                return null;
            }
            java.util.Set descriptors = (java.util.Set)this.descriptorsCache.get((Object)applicationName);
            if (descriptors == null) {
                return null;
            }
            cachedDescriptors.addAll(descriptors);
        }
        return Collections.unmodifiableSet(cachedDescriptors);
    }

    private Collection<ApplicationPrivilegeDescriptor> filterDescriptorsForPrivilegeNames(Collection<ApplicationPrivilegeDescriptor> descriptors, Collection<String> privilegeNames) {
        if (NativePrivilegeStore.isEmpty(privilegeNames)) {
            return descriptors;
        }
        return descriptors.stream().filter(d -> privilegeNames.contains(d.getName())).collect(Collectors.toSet());
    }

    protected void cacheFetchedDescriptors(java.util.Set<String> applicationNamesCacheKey, Map<String, java.util.Set<ApplicationPrivilegeDescriptor>> mapOfFetchedDescriptors) {
        java.util.Set<String> fetchedApplicationNames = Collections.unmodifiableSet(mapOfFetchedDescriptors.keySet());
        if (!fetchedApplicationNames.equals(applicationNamesCacheKey)) {
            logger.debug("Caching application names query: {} = {}", applicationNamesCacheKey, fetchedApplicationNames);
            this.applicationNamesCache.put(applicationNamesCacheKey, fetchedApplicationNames);
        }
        for (Map.Entry<String, java.util.Set<ApplicationPrivilegeDescriptor>> entry : mapOfFetchedDescriptors.entrySet()) {
            logger.debug("Caching descriptors for application: {}", (Object)entry.getKey());
            this.descriptorsCache.put((Object)entry.getKey(), entry.getValue());
        }
    }

    public void putPrivileges(Collection<ApplicationPrivilegeDescriptor> privileges, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        this.securityIndexManager.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                Map<String, List<String>> createdNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.CREATED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                this.clearCaches(listener, privileges.stream().map(ApplicationPrivilegeDescriptor::getApplication).collect(Collectors.toSet()), createdNames);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), privileges.size());
            for (ApplicationPrivilegeDescriptor privilege : privileges) {
                this.innerPutPrivilege(privilege, refreshPolicy, (ActionListener<IndexResponse>)groupListener);
            }
        });
    }

    private void innerPutPrivilege(ApplicationPrivilegeDescriptor privilege, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<IndexResponse> listener) {
        try {
            String name = privilege.getName();
            XContentBuilder xContentBuilder = privilege.toXContent(XContentFactory.jsonBuilder(), true);
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", "_doc", NativePrivilegeStore.toDocId(privilege.getApplication(), name)).setSource(xContentBuilder).setRefreshPolicy(refreshPolicy)).request()), listener, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        }
        catch (Exception e) {
            logger.warn("Failed to put privilege {} - {}", (Object)Strings.toString((ToXContent)privilege), (Object)e.toString());
            listener.onFailure(e);
        }
    }

    public void deletePrivileges(String application, Collection<String> names, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Map<String, List<String>>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndexManager.freeze();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse(Collections.emptyMap());
        } else if (!frozenSecurityIndex.isAvailable()) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason()));
        } else {
            this.securityIndexManager.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                GroupedActionListener groupListener = new GroupedActionListener(ActionListener.wrap(responses -> {
                    Map<String, List<String>> deletedNames = responses.stream().filter(r -> r.getResult() == DocWriteResponse.Result.DELETED).map(r -> r.getId()).map(NativePrivilegeStore::nameFromDocId).collect(TUPLES_TO_MAP);
                    this.clearCaches(listener, Collections.singleton(application), deletedNames);
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)), names.size());
                for (String name : names) {
                    ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)this.client.prepareDelete(".security", "_doc", NativePrivilegeStore.toDocId(application, name)).setRefreshPolicy(refreshPolicy)).request()), (ActionListener)groupListener, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
                }
            });
        }
    }

    private <T> void clearCaches(final ActionListener<T> listener, java.util.Set<String> applicationNames, final T value) {
        ClearPrivilegesCacheRequest request = new ClearPrivilegesCacheRequest().applicationNames(applicationNames.toArray(new String[0])).clearRolesCache(true);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearPrivilegesCacheAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<ClearPrivilegesCacheResponse>(){

            public void onResponse(ClearPrivilegesCacheResponse nodes) {
                listener.onResponse(value);
            }

            public void onFailure(Exception e) {
                logger.error("unable to clear application privileges and role cache", (Throwable)e);
                listener.onFailure((Exception)((Object)new ElasticsearchException("clearing the application privileges and role cache failed. please clear the caches manually", (Throwable)e, new Object[0])));
            }
        });
    }

    private static Tuple<String, String> nameFromDocId(String docId) {
        String name = docId.substring("application-privilege".length() + 1);
        assert (name != null && name.length() > 0) : "Invalid name '" + name + "'";
        int colon = name.indexOf(58);
        assert (colon > 0) : "Invalid name '" + name + "' (missing colon)";
        return new Tuple((Object)name.substring(0, colon), (Object)name.substring(colon + 1));
    }

    private static String toDocId(String application, String name) {
        return "application-privilege_" + application + ":" + name;
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.invalidateAll();
        }
    }

    public void invalidate(Collection<String> updatedApplicationNames) {
        if (this.descriptorsCache == null) {
            return;
        }
        try (ReleasableLock ignored = this.invalidationWriteLock.acquire();){
            this.numInvalidation.incrementAndGet();
        }
        logger.debug("Invalidating application privileges caches for: {}", updatedApplicationNames);
        java.util.Set uniqueNames = Set.copyOf(updatedApplicationNames);
        this.applicationNamesCache.invalidateAll();
        uniqueNames.forEach(arg_0 -> this.descriptorsCache.invalidate(arg_0));
    }

    public void invalidateAll() {
        if (this.descriptorsCache == null) {
            return;
        }
        try (ReleasableLock ignored = this.invalidationWriteLock.acquire();){
            this.numInvalidation.incrementAndGet();
        }
        logger.debug("Invalidating all application privileges caches");
        this.applicationNamesCache.invalidateAll();
        this.descriptorsCache.invalidateAll();
    }

    private static boolean isEmpty(Collection<String> collection) {
        return collection == null || collection.isEmpty();
    }

    Cache<java.util.Set<String>, java.util.Set<String>> getApplicationNamesCache() {
        return this.applicationNamesCache;
    }

    Cache<String, java.util.Set<ApplicationPrivilegeDescriptor>> getDescriptorsCache() {
        return this.descriptorsCache;
    }

    AtomicLong getNumInvalidation() {
        return this.numInvalidation;
    }

    private static /* synthetic */ Message lambda$innerGetPrivileges$5(Collection applications, QueryBuilder query) {
        return new ParameterizedMessage("Searching for [{}] privileges with query [{}]", (Object)applications, (Object)Strings.toString((ToXContent)query));
    }
}

