/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.time.ZoneId;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.sql.proto.Mode;

public class SqlConfiguration
extends Configuration {
    private final int pageSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    private final Mode mode;
    private final String clientId;
    private final boolean multiValueFieldLeniency;
    private final boolean includeFrozenIndices;
    @Nullable
    private QueryBuilder filter;

    public SqlConfiguration(ZoneId zi, int pageSize, TimeValue requestTimeout, TimeValue pageTimeout, QueryBuilder filter, Mode mode, String clientId, String username, String clusterName, boolean multiValueFieldLeniency, boolean includeFrozen) {
        super(zi, username, clusterName);
        this.pageSize = pageSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.mode = mode == null ? Mode.PLAIN : mode;
        this.clientId = clientId;
        this.multiValueFieldLeniency = multiValueFieldLeniency;
        this.includeFrozenIndices = includeFrozen;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Mode mode() {
        return this.mode;
    }

    public String clientId() {
        return this.clientId;
    }

    public boolean multiValueFieldLeniency() {
        return this.multiValueFieldLeniency;
    }

    public boolean includeFrozen() {
        return this.includeFrozenIndices;
    }
}

