/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.PivotExec;
import org.elasticsearch.xpack.sql.plan.physical.Unexecutable;
import org.elasticsearch.xpack.sql.plan.physical.UnplannedExec;

abstract class Verifier {
    Verifier() {
    }

    static List<Failure> verifyMappingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof UnplannedExec) {
                failures.add(Failure.fail((Node)p, (String)"Unplanned item", (Object[])new Object[0]));
            }
            p.forEachExpressionsUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        Verifier.checkInnerAggsPivot(plan, failures);
        return failures;
    }

    private static void checkInnerAggsPivot(PhysicalPlan plan, List<Failure> failures) {
        plan.forEachDown(p -> p.pivot().aggregates().forEach(agg -> agg.forEachDown(e -> {
            if (e instanceof InnerAggregate) {
                failures.add(Failure.fail((Node)e, (String)"Aggregation [{}] not supported (yet) by PIVOT", (Object[])new Object[]{e.sourceText()}));
            }
        })), PivotExec.class);
    }

    static List<Failure> verifyExecutingPlan(PhysicalPlan plan) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        plan.forEachUp(p -> {
            if (p instanceof Unexecutable) {
                failures.add(Failure.fail((Node)p, (String)"Unexecutable item", (Object[])new Object[0]));
            }
            p.forEachExpressionsUp(e -> {
                if (e.childrenResolved() && !e.resolved()) {
                    failures.add(Failure.fail((Node)e, (String)"Unresolved expression", (Object[])new Object[0]));
                }
            });
        });
        return failures;
    }
}

