/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;

public abstract class UnaryStringFunction
extends UnaryScalarFunction {
    protected UnaryStringFunction(Source source, Expression field) {
        super(source, field);
    }

    public boolean foldable() {
        return this.field().foldable();
    }

    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isStringAndExact((Expression)this.field(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.DEFAULT);
    }

    protected Processor makeProcessor() {
        return new StringProcessor(this.operation());
    }

    protected abstract StringProcessor.StringOperation operation();

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public String processScript(String template) {
        return this.formatTemplate(String.format(Locale.ROOT, "{sql}.%s(%s)", StringUtils.underscoreToLowerCamelCase((String)this.operation().name()), template));
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        UnaryStringFunction other = (UnaryStringFunction)((Object)obj);
        return Objects.equals(other.field(), this.field());
    }

    public int hashCode() {
        return Objects.hash(this.field());
    }
}

