/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryMathProcessor;

public abstract class BinaryNumericFunction
extends BinaryScalarFunction {
    private final BinaryMathProcessor.BinaryMathOperation operation;

    BinaryNumericFunction(Source source, Expression left, Expression right, BinaryMathProcessor.BinaryMathOperation operation) {
        super(source, left, right);
        this.operation = operation;
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isNumeric((Expression)this.left(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.right(), (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
    }

    public Object fold() {
        return this.operation.apply((Number)this.left().fold(), (Number)this.right().fold());
    }

    protected Pipe makePipe() {
        return new BinaryMathPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.left()), Expressions.pipe((Expression)this.right()), this.operation);
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.operation);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        BinaryNumericFunction other = (BinaryNumericFunction)((Object)obj);
        return Objects.equals(other.left(), this.left()) && Objects.equals(other.right(), this.right()) && Objects.equals(other.operation, this.operation);
    }
}

