/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.geo;

import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.StringUtils;
import org.elasticsearch.xpack.sql.expression.SqlTypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.GeoProcessor;

public abstract class UnaryGeoFunction
extends UnaryScalarFunction {
    protected UnaryGeoFunction(Source source, Expression field) {
        super(source, field);
    }

    public Object fold() {
        return this.operation().apply(this.field().fold());
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return SqlTypeResolutions.isGeo(this.field(), this.operation().toString(), Expressions.ParamOrdinal.DEFAULT);
    }

    protected Processor makeProcessor() {
        return new GeoProcessor(this.operation());
    }

    protected abstract GeoProcessor.GeoOperation operation();

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("{sql}.geoDocValue(doc,{})"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public String processScript(String template) {
        return super.processScript(String.format(Locale.ROOT, "{sql}.%s(%s)", StringUtils.underscoreToLowerCamelCase((String)("ST_" + this.operation().name())), template));
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        UnaryGeoFunction other = (UnaryGeoFunction)((Object)obj);
        return Objects.equals(other.field(), this.field());
    }

    public int hashCode() {
        return Objects.hash(this.field());
    }
}

