/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;

public class PercentileRank
extends AggregateFunction
implements EnclosedAgg {
    private final Expression value;

    public PercentileRank(Source source, Expression field, Expression value) {
        super(source, field, Collections.singletonList(value));
        this.value = value;
    }

    protected NodeInfo<PercentileRank> info() {
        return NodeInfo.create((Node)this, PercentileRank::new, (Object)this.field(), (Object)this.value);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new PercentileRank(this.source(), newChildren.get(0), newChildren.get(1));
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isFoldable((Expression)this.value, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = super.resolveType();
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.value, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.DEFAULT);
    }

    public Expression value() {
        return this.value;
    }

    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    public String innerName() {
        Double doubleValue = (Double)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)this.value), DataTypes.DOUBLE);
        return Double.toString(doubleValue);
    }
}

