/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;

public class Percentile
extends NumericAggregate
implements EnclosedAgg {
    private final Expression percent;

    public Percentile(Source source, Expression field, Expression percent) {
        super(source, field, Collections.singletonList(percent));
        this.percent = percent;
    }

    protected NodeInfo<Percentile> info() {
        return NodeInfo.create((Node)this, Percentile::new, (Object)this.field(), (Object)this.percent);
    }

    public Percentile replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 2) {
            throw new IllegalArgumentException("expected [2] children but received [" + newChildren.size() + "]");
        }
        return new Percentile(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = TypeResolutions.isFoldable((Expression)this.percent, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = super.resolveType();
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isNumeric((Expression)this.percent, (String)this.sourceText(), (Expressions.ParamOrdinal)Expressions.ParamOrdinal.DEFAULT);
    }

    public Expression percent() {
        return this.percent;
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    public String innerName() {
        Double value = (Double)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)this.percent), DataTypes.DOUBLE);
        return Double.toString(value);
    }
}

