/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.ql.execution.search.extractor.AbstractFieldHitExtractor;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public class FieldHitExtractor
extends AbstractFieldHitExtractor {
    static final String NAME = "f";

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue, boolean arrayLeniency) {
        super(name, dataType, zoneId, useDocValue, arrayLeniency);
    }

    public FieldHitExtractor(String name, DataType dataType, ZoneId zoneId, boolean useDocValue) {
        super(name, dataType, zoneId, useDocValue);
    }

    public FieldHitExtractor(String name, String fullFieldName, DataType dataType, ZoneId zoneId, boolean useDocValue, String hitName, boolean arrayLeniency) {
        super(name, fullFieldName, dataType, zoneId, useDocValue, hitName, arrayLeniency);
    }

    public FieldHitExtractor(StreamInput in) throws IOException {
        super(in);
    }

    protected DataType loadTypeFromName(String typeName) {
        return SqlDataTypes.fromTypeName(typeName);
    }

    protected ZoneId readZoneId(StreamInput in) throws IOException {
        return SqlStreamInput.asSqlStream(in).zoneId();
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean isPrimitive(List<?> list) {
        return this.isGeoPointArray(list);
    }

    private boolean isGeoPointArray(List<?> list) {
        if (this.dataType() != SqlDataTypes.GEO_POINT) {
            return false;
        }
        if (list.size() > 3 || list.size() < 1) {
            return false;
        }
        return list.get(0) instanceof Number;
    }

    protected boolean isFromDocValuesOnly(DataType dataType) {
        return SqlDataTypes.isFromDocValuesOnly(dataType);
    }

    protected Object unwrapCustomValue(Object values) {
        DataType dataType = this.dataType();
        if (dataType == SqlDataTypes.GEO_POINT) {
            try {
                GeoPoint geoPoint = GeoUtils.parseGeoPoint((Object)values, (boolean)true);
                return new GeoShape(geoPoint.lon(), geoPoint.lat());
            }
            catch (ElasticsearchParseException ex) {
                throw new SqlIllegalArgumentException("Cannot parse geo_point value [{}] (returned by [{}])", values, this.fieldName());
            }
        }
        if (dataType == SqlDataTypes.GEO_SHAPE) {
            try {
                return new GeoShape(values);
            }
            catch (IOException ex) {
                throw new SqlIllegalArgumentException("Cannot read geo_shape value [{}] (returned by [{}])", values, this.fieldName());
            }
        }
        if (dataType == SqlDataTypes.SHAPE) {
            try {
                return new GeoShape(values);
            }
            catch (IOException ex) {
                throw new SqlIllegalArgumentException("Cannot read shape value [{}] (returned by [{}])", values, this.fieldName());
            }
        }
        if (values instanceof Map) {
            throw new SqlIllegalArgumentException("Objects (returned by [{}]) are not supported", this.fieldName());
        }
        if (dataType == DataTypes.DATETIME && values instanceof String) {
            return DateUtils.asDateTime(Long.parseLong(values.toString()), this.zoneId());
        }
        return null;
    }
}

