/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.sql.analysis.analyzer.TableInfo;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    private PreAnalysis doPreAnalyze(LogicalPlan plan) {
        ArrayList<TableInfo> indices = new ArrayList<TableInfo>();
        plan.forEachUp(p -> indices.add(new TableInfo(p.table(), p.frozen())), UnresolvedRelation.class);
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis(indices);
    }

    public static class PreAnalysis {
        public static final PreAnalysis EMPTY = new PreAnalysis(Collections.emptyList());
        public final List<TableInfo> indices;

        PreAnalysis(List<TableInfo> indices) {
            this.indices = indices;
        }
    }
}

