/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortValue;
import org.elasticsearch.xpack.analytics.topmetrics.InternalTopMetrics;

class TopMetricsAggregator
extends NumericMetricsAggregator.MultiValue {
    private final int size;
    private final BucketedSort sort;
    private final Metrics metrics;

    TopMetricsAggregator(String name, SearchContext context, Aggregator parent, Map<String, Object> metadata, int size, SortBuilder<?> sort, List<MetricSource> metricSources) throws IOException {
        super(name, context, parent, metadata);
        this.size = size;
        this.metrics = new Metrics(size, context.getQueryShardContext().bigArrays(), metricSources);
        Metrics values = metricSources.size() == 1 ? this.metrics.values[0] : this.metrics;
        this.sort = sort.buildBucketedSort(context.getQueryShardContext(), size, (BucketedSort.ExtraData)values);
    }

    public boolean hasMetric(String name) {
        if (this.size != 1) {
            throw new IllegalArgumentException("[top_metrics] can only the be target if [size] is [1] but was [" + this.size + "]");
        }
        for (MetricValues values : this.metrics.values) {
            if (!values.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public double metric(String name, long owningBucketOrd) {
        assert (this.size == 1);
        return this.metrics.metric(name, owningBucketOrd);
    }

    public ScoreMode scoreMode() {
        boolean needs = this.sort.needsScores() || this.metrics.needsScores();
        return needs ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        assert (sub == LeafBucketCollector.NO_OP_COLLECTOR) : "Expected noop but was " + sub.toString();
        final BucketedSort.Leaf leafSort = this.sort.forLeaf(ctx);
        return new LeafBucketCollector(){

            public void collect(int doc, long bucket) throws IOException {
                leafSort.collect(doc, bucket);
            }

            public void setScorer(Scorable s) throws IOException {
                leafSort.setScorer(s);
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) throws IOException {
        List topMetrics = this.sort.getValues(bucket, this.metrics.resultBuilder(this.sort.getFormat()));
        assert (topMetrics.size() <= this.size);
        return new InternalTopMetrics(this.name, this.sort.getOrder(), this.metrics.names(), this.size, topMetrics, this.metadata());
    }

    public InternalTopMetrics buildEmptyAggregation() {
        return InternalTopMetrics.buildEmptyAggregation(this.name, this.metrics.names(), this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sort, this.metrics});
    }

    static class Metrics
    implements BucketedSort.ExtraData,
    Releasable {
        private final MetricValues[] values;

        Metrics(int size, BigArrays bigArrays, List<MetricSource> sources) {
            this.values = new MetricValues[sources.size()];
            int i = 0;
            for (MetricSource source : sources) {
                this.values[i++] = Metrics.valuesFor(size, bigArrays, source);
            }
        }

        private static MetricValues valuesFor(int size, BigArrays bigArrays, MetricSource source) {
            if (source.valuesSource == null) {
                return new AlwaysNullMetricValues(source);
            }
            if (source.valuesSource.isFloatingPoint()) {
                return new DoubleMetricValues(size, bigArrays, source);
            }
            return new LongMetricValues(size, bigArrays, source);
        }

        boolean needsScores() {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].needsScores()) continue;
                return true;
            }
            return false;
        }

        double metric(String name, long index) {
            for (MetricValues value : this.values) {
                if (!value.name().equals(name)) continue;
                return value.doubleValue(index);
            }
            throw new IllegalArgumentException("[" + name + "] not found");
        }

        BucketedSort.ResultBuilder<InternalTopMetrics.TopMetric> resultBuilder(DocValueFormat sortFormat) {
            return (index, sortValue) -> {
                ArrayList<InternalTopMetrics.MetricValue> result = new ArrayList<InternalTopMetrics.MetricValue>(this.values.length);
                for (int i = 0; i < this.values.length; ++i) {
                    result.add(this.values[i].metricValue(index));
                }
                return new InternalTopMetrics.TopMetric(sortFormat, sortValue, result);
            };
        }

        List<String> names() {
            return Arrays.stream(this.values).map(MetricValues::name).collect(Collectors.toList());
        }

        public void swap(long lhs, long rhs) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].swap(lhs, rhs);
            }
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            BucketedSort.ExtraData.Loader[] loaders = new BucketedSort.ExtraData.Loader[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                loaders[i] = this.values[i].loader(ctx);
            }
            return (index, doc) -> {
                for (int i = 0; i < loaders.length; ++i) {
                    loaders[i].loadFromDoc(index, doc);
                }
            };
        }

        public void close() {
            Releasables.close((Releasable[])this.values);
        }
    }

    private static abstract class MetricValues
    implements BucketedSort.ExtraData,
    Releasable {
        protected final MetricSource source;

        MetricValues(MetricSource source) {
            this.source = source;
        }

        final String name() {
            return this.source.name;
        }

        abstract boolean needsScores();

        abstract double doubleValue(long var1);

        abstract InternalTopMetrics.MetricValue metricValue(long var1);
    }

    private static class MissingHelper
    implements Releasable {
        private final BigArrays bigArrays;
        private BitArray tracker;

        MissingHelper(BigArrays bigArrays) {
            this.bigArrays = bigArrays;
        }

        void markMissing(long index) {
            if (this.tracker == null) {
                this.tracker = new BitArray(index, this.bigArrays);
            }
            this.tracker.set(index);
        }

        void markNotMissing(long index) {
            if (this.tracker == null) {
                return;
            }
            this.tracker.clear(index);
        }

        void swap(long lhs, long rhs) {
            if (this.tracker == null) {
                return;
            }
            boolean backup = this.tracker.get(lhs);
            if (this.tracker.get(rhs)) {
                this.tracker.set(lhs);
            } else {
                this.tracker.clear(lhs);
            }
            if (backup) {
                this.tracker.set(rhs);
            } else {
                this.tracker.clear(rhs);
            }
        }

        boolean isEmpty(long index) {
            if (this.tracker == null) {
                return false;
            }
            return this.tracker.get(index);
        }

        public void close() {
            if (this.tracker != null) {
                this.tracker.close();
            }
        }
    }

    static class AlwaysNullMetricValues
    extends MetricValues {
        AlwaysNullMetricValues(MetricSource source) {
            super(source);
        }

        @Override
        public double doubleValue(long index) {
            return Double.NaN;
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) {
            return null;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        public void swap(long lhs, long rhs) {
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            return (index, doc) -> {};
        }

        public void close() {
        }
    }

    static class LongMetricValues
    extends CollectingMetricValues {
        private final MissingHelper empty;
        private LongArray values;

        LongMetricValues(int size, BigArrays bigArrays, MetricSource source) {
            super(bigArrays, source);
            this.empty = new MissingHelper(bigArrays);
            this.values = bigArrays.newLongArray((long)size, false);
        }

        @Override
        public double doubleValue(long index) {
            if (this.empty.isEmpty(index)) {
                return Double.NaN;
            }
            return this.values.get(index);
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) {
            if (this.empty.isEmpty(index)) {
                return null;
            }
            return new InternalTopMetrics.MetricValue(this.source.format, SortValue.from((long)this.values.get(index)));
        }

        public void swap(long lhs, long rhs) {
            long tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
            this.empty.swap(lhs, rhs);
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            NumericDocValues metricValues = MultiValueMode.AVG.select(this.source.valuesSource.longValues(ctx));
            return (index, doc) -> {
                if (!metricValues.advanceExact(doc)) {
                    this.empty.markMissing(index);
                    return;
                }
                if (index >= this.values.size()) {
                    this.values = this.bigArrays.grow(this.values, index + 1L);
                }
                this.values.set(index, metricValues.longValue());
                this.empty.markNotMissing(index);
            };
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.values, this.empty});
        }
    }

    static class DoubleMetricValues
    extends CollectingMetricValues {
        private DoubleArray values;

        DoubleMetricValues(int size, BigArrays bigArrays, MetricSource source) {
            super(bigArrays, source);
            this.values = bigArrays.newDoubleArray((long)size, false);
        }

        @Override
        public double doubleValue(long index) {
            return this.values.get(index);
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) {
            double value = this.values.get(index);
            if (Double.isNaN(value)) {
                return null;
            }
            return new InternalTopMetrics.MetricValue(this.source.format, SortValue.from((double)value));
        }

        public void swap(long lhs, long rhs) {
            double tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            NumericDoubleValues metricValues = MultiValueMode.AVG.select(this.source.valuesSource.doubleValues(ctx));
            return (index, doc) -> {
                if (index >= this.values.size()) {
                    this.values = this.bigArrays.grow(this.values, index + 1L);
                }
                double metricValue = metricValues.advanceExact(doc) ? metricValues.doubleValue() : Double.NaN;
                this.values.set(index, metricValue);
            };
        }

        public void close() {
            this.values.close();
        }
    }

    private static abstract class CollectingMetricValues
    extends MetricValues {
        protected final BigArrays bigArrays;

        CollectingMetricValues(BigArrays bigArrays, MetricSource source) {
            super(source);
            this.bigArrays = bigArrays;
        }

        @Override
        public final boolean needsScores() {
            return this.source.valuesSource.needsScores();
        }
    }

    static class MetricSource {
        private final String name;
        private final DocValueFormat format;
        private final ValuesSource.Numeric valuesSource;

        MetricSource(String name, DocValueFormat format, ValuesSource.Numeric valuesSource) {
            this.name = name;
            this.format = format;
            this.valuesSource = valuesSource;
        }

        String getName() {
            return this.name;
        }

        DocValueFormat getFormat() {
            return this.format;
        }
    }
}

