/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregatorFactory;

public class TopMetricsAggregationBuilder
extends AbstractAggregationBuilder<TopMetricsAggregationBuilder> {
    public static final String NAME = "top_metrics";
    public static final ParseField METRIC_FIELD = new ParseField("metrics", new String[0]);
    private static final int DEFAULT_SIZE = 1;
    public static final ConstructingObjectParser<TopMetricsAggregationBuilder, String> PARSER = new ConstructingObjectParser("top_metrics", false, (args, name) -> {
        int size;
        List sorts = (List)args[0];
        int n = size = args[1] == null ? 1 : (Integer)args[1];
        if (size < 1) {
            throw new IllegalArgumentException("[size] must be more than 0 but was [" + size + "]");
        }
        List metricFields = (List)args[2];
        return new TopMetricsAggregationBuilder((String)name, sorts, size, metricFields);
    });
    private final List<SortBuilder<?>> sortBuilders;
    private final int size;
    private final List<MultiValuesSourceFieldConfig> metricFields;

    public TopMetricsAggregationBuilder(String name, List<SortBuilder<?>> sortBuilders, int size, List<MultiValuesSourceFieldConfig> metricFields) {
        super(name);
        if (sortBuilders.size() != 1) {
            throw new IllegalArgumentException("[sort] must contain exactly one sort");
        }
        this.sortBuilders = sortBuilders;
        this.size = size;
        this.metricFields = metricFields;
    }

    public TopMetricsAggregationBuilder(TopMetricsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super((AbstractAggregationBuilder)clone, factoriesBuilder, metadata);
        this.sortBuilders = clone.sortBuilders;
        this.size = clone.size;
        this.metricFields = clone.metricFields;
    }

    public TopMetricsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        List sortBuilders;
        this.sortBuilders = sortBuilders = in.readNamedWriteableList(SortBuilder.class);
        this.size = in.readVInt();
        this.metricFields = in.readList(MultiValuesSourceFieldConfig::new);
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.sortBuilders);
        out.writeVInt(this.size);
        out.writeList(this.metricFields);
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new TopMetricsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new TopMetricsAggregatorFactory(this.name, queryShardContext, parent, subFactoriesBuilder, this.metadata, this.sortBuilders, this.size, this.metricFields);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(SearchSourceBuilder.SORT_FIELD.getPreferredName());
        for (SortBuilder<?> sort : this.sortBuilders) {
            sort.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(SearchSourceBuilder.SIZE_FIELD.getPreferredName(), this.size);
        builder.startArray(METRIC_FIELD.getPreferredName());
        for (MultiValuesSourceFieldConfig metricField : this.metricFields) {
            metricField.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String getType() {
        return NAME;
    }

    List<SortBuilder<?>> getSortBuilders() {
        return this.sortBuilders;
    }

    int getSize() {
        return this.size;
    }

    List<MultiValuesSourceFieldConfig> getMetricFields() {
        return this.metricFields;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, n) -> SortBuilder.fromXContent((XContentParser)p), SearchSourceBuilder.SORT_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SearchSourceBuilder.SIZE_FIELD);
        ContextParser metricParser = (ContextParser)MultiValuesSourceFieldConfig.PARSER.apply((Object)true, (Object)false, (Object)false);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, n) -> ((MultiValuesSourceFieldConfig.Builder)metricParser.parse(p, null)).build(), METRIC_FIELD);
    }
}

