/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.stringstats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xpack.analytics.stringstats.InternalStringStats;

public class StringStatsAggregator
extends MetricsAggregator {
    final ValuesSource.Bytes valuesSource;
    final DocValueFormat format;
    private final boolean showDistribution;
    LongArray count;
    IntArray minLength;
    IntArray maxLength;
    LongArray totalLength;
    Map<Character, LongArray> charOccurrences;

    StringStatsAggregator(String name, ValuesSource valuesSource, boolean showDistribution, DocValueFormat format, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.showDistribution = showDistribution;
        this.valuesSource = (ValuesSource.Bytes)valuesSource;
        if (valuesSource != null) {
            BigArrays bigArrays = context.bigArrays();
            this.count = bigArrays.newLongArray(1L, true);
            this.totalLength = bigArrays.newLongArray(1L, true);
            this.minLength = bigArrays.newIntArray(1L, false);
            this.minLength.fill(0L, this.minLength.size(), Integer.MAX_VALUE);
            this.maxLength = bigArrays.newIntArray(1L, false);
            this.maxLength.fill(0L, this.maxLength.size(), Integer.MIN_VALUE);
            this.charOccurrences = new HashMap<Character, LongArray>();
        }
        this.format = format;
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                long overSize = BigArrays.overSize((long)(bucket + 1L));
                if (bucket >= StringStatsAggregator.this.count.size()) {
                    long from = StringStatsAggregator.this.count.size();
                    StringStatsAggregator.this.count = bigArrays.resize(StringStatsAggregator.this.count, overSize);
                    StringStatsAggregator.this.totalLength = bigArrays.resize(StringStatsAggregator.this.totalLength, overSize);
                    StringStatsAggregator.this.minLength = bigArrays.resize(StringStatsAggregator.this.minLength, overSize);
                    StringStatsAggregator.this.maxLength = bigArrays.resize(StringStatsAggregator.this.maxLength, overSize);
                    StringStatsAggregator.this.minLength.fill(from, overSize, Integer.MAX_VALUE);
                    StringStatsAggregator.this.maxLength.fill(from, overSize, Integer.MIN_VALUE);
                }
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    StringStatsAggregator.this.count.increment(bucket, (long)valuesCount);
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef value = values.nextValue();
                        if (value.length <= 0) continue;
                        String valueStr = (String)StringStatsAggregator.this.format.format(value);
                        int length = valueStr.length();
                        StringStatsAggregator.this.totalLength.increment(bucket, (long)length);
                        int min = Math.min(StringStatsAggregator.this.minLength.get(bucket), length);
                        int max = Math.max(StringStatsAggregator.this.maxLength.get(bucket), length);
                        StringStatsAggregator.this.minLength.set(bucket, min);
                        StringStatsAggregator.this.maxLength.set(bucket, max);
                        char[] cArray = valueStr.toCharArray();
                        int n = cArray.length;
                        for (int j = 0; j < n; ++j) {
                            Character c = Character.valueOf(cArray[j]);
                            LongArray occ = StringStatsAggregator.this.charOccurrences.get(c);
                            if (occ == null) {
                                occ = bigArrays.newLongArray(overSize, true);
                            } else if (bucket >= occ.size()) {
                                occ = bigArrays.resize(occ, overSize);
                            }
                            occ.increment(bucket, 1L);
                            StringStatsAggregator.this.charOccurrences.put(c, occ);
                        }
                    }
                }
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.count.size()) {
            return this.buildEmptyAggregation();
        }
        HashMap<String, Long> occurrences = new HashMap<String, Long>(this.charOccurrences.size());
        for (Map.Entry<Character, LongArray> e : this.charOccurrences.entrySet()) {
            long occ;
            if (e.getValue().size() <= bucket || (occ = e.getValue().get(bucket)) <= 0L) continue;
            occurrences.put(e.getKey().toString(), occ);
        }
        return new InternalStringStats(this.name, this.count.get(bucket), this.totalLength.get(bucket), this.minLength.get(bucket), this.maxLength.get(bucket), occurrences, this.showDistribution, this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalStringStats(this.name, 0L, 0L, Integer.MAX_VALUE, Integer.MIN_VALUE, Collections.emptyMap(), this.showDistribution, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.maxLength, this.minLength, this.count, this.totalLength});
        if (this.charOccurrences != null) {
            Releasables.close(this.charOccurrences.values());
        }
    }
}

