/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.actions.throttler;

import java.time.Clock;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.watcher.actions.throttler.AckThrottler;
import org.elasticsearch.xpack.core.watcher.actions.throttler.PeriodThrottler;
import org.elasticsearch.xpack.core.watcher.actions.throttler.Throttler;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public class ActionThrottler
implements Throttler {
    private static final AckThrottler ACK_THROTTLER = new AckThrottler();
    private final XPackLicenseState licenseState;
    private final PeriodThrottler periodThrottler;
    private final AckThrottler ackThrottler;

    public ActionThrottler(Clock clock, @Nullable TimeValue throttlePeriod, XPackLicenseState licenseState) {
        this(new PeriodThrottler(clock, throttlePeriod), ACK_THROTTLER, licenseState);
    }

    ActionThrottler(PeriodThrottler periodThrottler, AckThrottler ackThrottler, XPackLicenseState licenseState) {
        this.periodThrottler = periodThrottler;
        this.ackThrottler = ackThrottler;
        this.licenseState = licenseState;
    }

    public TimeValue throttlePeriod() {
        return this.periodThrottler != null ? this.periodThrottler.period() : null;
    }

    @Override
    public Throttler.Result throttle(String actionId, WatchExecutionContext ctx) {
        Throttler.Result throttleResult;
        if (!this.licenseState.checkFeature(XPackLicenseState.Feature.WATCHER)) {
            return Throttler.Result.throttle(Throttler.Type.LICENSE, "watcher license does not allow action execution", new Object[0]);
        }
        if (this.periodThrottler != null && (throttleResult = this.periodThrottler.throttle(actionId, ctx)).throttle()) {
            return throttleResult;
        }
        return this.ackThrottler.throttle(actionId, ctx);
    }
}

