/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.DestConfig;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.transforms.SourceConfig;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.pivot.PivotConfig;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class TransformConfig
extends AbstractDiffable<TransformConfig>
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame_transform_config";
    public static final ParseField HEADERS = new ParseField("headers", new String[0]);
    public static final ParseField PIVOT_TRANSFORM = new ParseField("pivot", new String[0]);
    private static final ConstructingObjectParser<TransformConfig, String> STRICT_PARSER = TransformConfig.createParser(false);
    private static final ConstructingObjectParser<TransformConfig, String> LENIENT_PARSER = TransformConfig.createParser(true);
    static final int MAX_DESCRIPTION_LENGTH = 1000;
    private final String id;
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final SettingsConfig settings;
    private final String description;
    private Map<String, String> headers;
    private Version transformVersion;
    private Instant createTime;
    private final PivotConfig pivotConfig;

    private static void validateStrictParsingParams(Object arg, String parameterName) {
        if (arg != null) {
            throw new IllegalArgumentException("Found [" + parameterName + "], not allowed for strict parsing");
        }
    }

    private static ConstructingObjectParser<TransformConfig, String> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, (args, optionalId) -> {
            String id = (String)args[0];
            if (id == null) {
                id = optionalId;
            } else if (optionalId != null && !id.equals(optionalId)) {
                throw new IllegalArgumentException(TransformMessages.getMessage("Inconsistent id; ''{0}'' specified in the body differs from ''{1}'' specified as a URL argument", id, optionalId));
            }
            SourceConfig source = (SourceConfig)args[1];
            DestConfig dest = (DestConfig)args[2];
            TimeValue frequency = args[3] == null ? null : TimeValue.parseTimeValue((String)((String)args[3]), (String)TransformField.FREQUENCY.getPreferredName());
            SyncConfig syncConfig = (SyncConfig)args[4];
            if (!lenient) {
                TransformConfig.validateStrictParsingParams(args[6], HEADERS.getPreferredName());
                TransformConfig.validateStrictParsingParams(args[10], TransformField.CREATE_TIME.getPreferredName());
                TransformConfig.validateStrictParsingParams(args[11], TransformField.VERSION.getPreferredName());
            }
            Map headers = (Map)args[6];
            PivotConfig pivotConfig = (PivotConfig)args[7];
            String description = (String)args[8];
            SettingsConfig settings = (SettingsConfig)args[9];
            return new TransformConfig(id, source, dest, frequency, syncConfig, headers, pivotConfig, description, settings, (Instant)args[10], (String)args[11]);
        });
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.ID);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SourceConfig.fromXContent(p, lenient), TransformField.SOURCE);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DestConfig.fromXContent(p, lenient), TransformField.DESTINATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.FREQUENCY);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TransformConfig.parseSyncConfig(p, lenient), TransformField.SYNC);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.INDEX_DOC_TYPE);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), HEADERS);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PivotConfig.fromXContent(p, lenient), PIVOT_TRANSFORM);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.DESCRIPTION);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfig.fromXContent(p, lenient), TransformField.SETTINGS);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, TransformField.CREATE_TIME.getPreferredName()), TransformField.CREATE_TIME, ObjectParser.ValueType.VALUE);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.VERSION);
        return parser;
    }

    private static SyncConfig parseSyncConfig(XContentParser parser, boolean ignoreUnknownFields) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        SyncConfig syncConfig = (SyncConfig)parser.namedObject(SyncConfig.class, parser.currentName(), (Object)ignoreUnknownFields);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return syncConfig;
    }

    public static String documentId(String transformId) {
        return "data_frame_transform_config-" + transformId;
    }

    TransformConfig(String id, SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, Map<String, String> headers, PivotConfig pivotConfig, String description, SettingsConfig settings, Instant createTime, String version) {
        this.id = ExceptionsHelper.requireNonNull(id, TransformField.ID.getPreferredName());
        this.source = ExceptionsHelper.requireNonNull(source, TransformField.SOURCE.getPreferredName());
        this.dest = ExceptionsHelper.requireNonNull(dest, TransformField.DESTINATION.getPreferredName());
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.setHeaders(headers == null ? Collections.emptyMap() : headers);
        this.pivotConfig = pivotConfig;
        this.description = description;
        SettingsConfig settingsConfig = this.settings = settings == null ? new SettingsConfig() : settings;
        if (this.pivotConfig == null) {
            throw new IllegalArgumentException("Transform configuration must specify exactly 1 function");
        }
        if (this.description != null && this.description.length() > 1000) {
            throw new IllegalArgumentException("[description] must be less than 1000 characters in length.");
        }
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.transformVersion = version == null ? null : Version.fromString((String)version);
    }

    public TransformConfig(String id, SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, Map<String, String> headers, PivotConfig pivotConfig, String description, SettingsConfig settings) {
        this(id, source, dest, frequency, syncConfig, headers, pivotConfig, description, settings, null, null);
    }

    public TransformConfig(StreamInput in) throws IOException {
        this.id = in.readString();
        this.source = new SourceConfig(in);
        this.dest = new DestConfig(in);
        this.frequency = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readOptionalTimeValue() : null;
        this.setHeaders(in.readMap(StreamInput::readString, StreamInput::readString));
        this.pivotConfig = (PivotConfig)in.readOptionalWriteable(PivotConfig::new);
        this.description = in.readOptionalString();
        if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
            this.syncConfig = (SyncConfig)in.readOptionalNamedWriteable(SyncConfig.class);
            this.createTime = in.readOptionalInstant();
            this.transformVersion = in.readBoolean() ? Version.readVersion((StreamInput)in) : null;
        } else {
            this.syncConfig = null;
            this.createTime = null;
            this.transformVersion = null;
        }
        this.settings = in.getVersion().onOrAfter(Version.V_7_8_0) ? new SettingsConfig(in) : new SettingsConfig();
    }

    public String getId() {
        return this.id;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TransformConfig setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Version getVersion() {
        return this.transformVersion;
    }

    public TransformConfig setVersion(Version transformVersion) {
        this.transformVersion = transformVersion;
        return this;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public TransformConfig setCreateTime(Instant createTime) {
        ExceptionsHelper.requireNonNull(createTime, TransformField.CREATE_TIME.getPreferredName());
        this.createTime = Instant.ofEpochMilli(createTime.toEpochMilli());
        return this;
    }

    public PivotConfig getPivotConfig() {
        return this.pivotConfig;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public SettingsConfig getSettings() {
        return this.settings;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.pivotConfig != null) {
            validationException = this.pivotConfig.validate(validationException);
        }
        validationException = this.settings.validate(validationException);
        return validationException;
    }

    public boolean isValid() {
        if (this.pivotConfig != null && !this.pivotConfig.isValid()) {
            return false;
        }
        if (this.syncConfig != null && !this.syncConfig.isValid()) {
            return false;
        }
        return this.settings.isValid() && this.source.isValid() && this.dest.isValid();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        this.source.writeTo(out);
        this.dest.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalTimeValue(this.frequency);
        }
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
        out.writeOptionalWriteable((Writeable)this.pivotConfig);
        out.writeOptionalString(this.description);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.syncConfig);
            out.writeOptionalInstant(this.createTime);
            if (this.transformVersion != null) {
                out.writeBoolean(true);
                Version.writeVersion((Version)this.transformVersion, (StreamOutput)out);
            } else {
                out.writeBoolean(false);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            this.settings.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.id);
        builder.field(TransformField.SOURCE.getPreferredName(), (ToXContent)this.source);
        builder.field(TransformField.DESTINATION.getPreferredName(), (ToXContent)this.dest);
        if (this.frequency != null) {
            builder.field(TransformField.FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.syncConfig != null) {
            builder.startObject(TransformField.SYNC.getPreferredName());
            builder.field(this.syncConfig.getWriteableName(), (ToXContent)this.syncConfig);
            builder.endObject();
        }
        if (this.pivotConfig != null) {
            builder.field(PIVOT_TRANSFORM.getPreferredName(), (ToXContent)this.pivotConfig);
        }
        if (params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(TransformField.INDEX_DOC_TYPE.getPreferredName(), NAME);
        }
        if (!this.headers.isEmpty() && params.paramAsBoolean("for_internal_storage", false)) {
            builder.field(HEADERS.getPreferredName(), this.headers);
        }
        if (this.description != null) {
            builder.field(TransformField.DESCRIPTION.getPreferredName(), this.description);
        }
        builder.field(TransformField.SETTINGS.getPreferredName(), (ToXContent)this.settings);
        if (this.transformVersion != null) {
            builder.field(TransformField.VERSION.getPreferredName(), (ToXContent)this.transformVersion);
        }
        if (this.createTime != null) {
            builder.timeField(TransformField.CREATE_TIME.getPreferredName(), TransformField.CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        TransformConfig that = (TransformConfig)((Object)other);
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pivotConfig, that.pivotConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.transformVersion, that.transformVersion);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.description, this.settings, this.createTime, this.transformVersion);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static TransformConfig fromXContent(XContentParser parser, @Nullable String optionalTransformId, boolean lenient) {
        return lenient ? (TransformConfig)((Object)LENIENT_PARSER.apply(parser, (Object)optionalTransformId)) : (TransformConfig)((Object)STRICT_PARSER.apply(parser, (Object)optionalTransformId));
    }

    public static TransformConfig rewriteForUpdate(TransformConfig transformConfig) {
        if (transformConfig.getPivotConfig() == null || transformConfig.getPivotConfig().getMaxPageSearchSize() == null) {
            return transformConfig;
        }
        Builder builder = new Builder(transformConfig);
        if (transformConfig.getPivotConfig() != null && transformConfig.getPivotConfig().getMaxPageSearchSize() != null) {
            PivotConfig newPivotConfig = new PivotConfig(transformConfig.getPivotConfig().getGroupConfig(), transformConfig.getPivotConfig().getAggregationConfig(), null);
            builder.setPivotConfig(newPivotConfig);
            Integer maxPageSearchSizeDeprecated = transformConfig.getPivotConfig().getMaxPageSearchSize();
            Integer maxPageSearchSize = transformConfig.getSettings().getMaxPageSearchSize() != null ? transformConfig.getSettings().getMaxPageSearchSize() : maxPageSearchSizeDeprecated;
            builder.setSettings(new SettingsConfig(maxPageSearchSize, transformConfig.getSettings().getDocsPerSecond()));
        }
        return builder.setVersion(Version.CURRENT).build();
    }

    public static class Builder {
        private String id;
        private SourceConfig source;
        private DestConfig dest;
        private TimeValue frequency;
        private SyncConfig syncConfig;
        private String description;
        private Map<String, String> headers;
        private Version transformVersion;
        private Instant createTime;
        private PivotConfig pivotConfig;
        private SettingsConfig settings;

        public Builder() {
        }

        public Builder(TransformConfig config) {
            this.id = config.id;
            this.source = config.source;
            this.dest = config.dest;
            this.frequency = config.frequency;
            this.syncConfig = config.syncConfig;
            this.description = config.description;
            this.transformVersion = config.transformVersion;
            this.createTime = config.createTime;
            this.pivotConfig = config.pivotConfig;
            this.settings = config.settings;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder setSyncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSettings(SettingsConfig settings) {
            this.settings = settings;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder setPivotConfig(PivotConfig pivotConfig) {
            this.pivotConfig = pivotConfig;
            return this;
        }

        Builder setVersion(Version version) {
            this.transformVersion = version;
            return this;
        }

        public TransformConfig build() {
            return new TransformConfig(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.description, this.settings, this.createTime, this.transformVersion == null ? null : this.transformVersion.toString());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Builder that = (Builder)other;
            return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.headers, that.headers) && Objects.equals(this.pivotConfig, that.pivotConfig) && Objects.equals(this.description, that.description) && Objects.equals(this.settings, that.settings) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.transformVersion, that.transformVersion);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.headers, this.pivotConfig, this.description, this.settings, this.createTime, this.transformVersion);
        }
    }
}

