/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.SyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;

public class TimeSyncConfig
implements SyncConfig {
    public static final TimeValue DEFAULT_DELAY = TimeValue.timeValueSeconds((long)60L);
    private static final String NAME = "data_frame_transform_pivot_sync_time";
    private final String field;
    private final TimeValue delay;
    private static final ConstructingObjectParser<TimeSyncConfig, Void> STRICT_PARSER = TimeSyncConfig.createParser(false);
    private static final ConstructingObjectParser<TimeSyncConfig, Void> LENIENT_PARSER = TimeSyncConfig.createParser(true);

    private static ConstructingObjectParser<TimeSyncConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, lenient, args -> {
            String field = (String)args[0];
            TimeValue delay = (TimeValue)args[1];
            return new TimeSyncConfig(field, delay);
        });
        parser.declareString(ConstructingObjectParser.constructorArg(), TransformField.FIELD);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue((String)p.text(), (TimeValue)DEFAULT_DELAY, (String)TransformField.DELAY.getPreferredName()), TransformField.DELAY, ObjectParser.ValueType.STRING);
        return parser;
    }

    public TimeSyncConfig() {
        this(null, null);
    }

    public TimeSyncConfig(String field, TimeValue delay) {
        this.field = ExceptionsHelper.requireNonNull(field, TransformField.FIELD.getPreferredName());
        this.delay = delay == null ? DEFAULT_DELAY : delay;
    }

    public TimeSyncConfig(StreamInput in) throws IOException {
        this.field = in.readString();
        this.delay = in.readTimeValue();
    }

    @Override
    public String getField() {
        return this.field;
    }

    public TimeValue getDelay() {
        return this.delay;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeTimeValue(this.delay);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.FIELD.getPreferredName(), this.field);
        builder.field(TransformField.DELAY.getPreferredName(), this.delay.getStringRep());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeSyncConfig that = (TimeSyncConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.delay);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static TimeSyncConfig parse(XContentParser parser) {
        return (TimeSyncConfig)LENIENT_PARSER.apply(parser, null);
    }

    public static TimeSyncConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (TimeSyncConfig)LENIENT_PARSER.apply(parser, null) : (TimeSyncConfig)STRICT_PARSER.apply(parser, null);
    }

    public String getWriteableName() {
        return TransformField.TIME_BASED_SYNC.getPreferredName();
    }

    @Override
    public QueryBuilder getRangeQuery(TransformCheckpoint newCheckpoint) {
        return new RangeQueryBuilder(this.field).lt((Object)newCheckpoint.getTimeUpperBound()).format("epoch_millis");
    }

    @Override
    public QueryBuilder getRangeQuery(TransformCheckpoint oldCheckpoint, TransformCheckpoint newCheckpoint) {
        return new RangeQueryBuilder(this.field).gte((Object)oldCheckpoint.getTimeUpperBound()).lt((Object)newCheckpoint.getTimeUpperBound()).format("epoch_millis");
    }
}

