/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class TemplateUtils {
    private TemplateUtils() {
    }

    public static void loadTemplateIntoMap(String resource, Map<String, IndexTemplateMetadata> map, String templateName, String version, String versionProperty, Logger logger) {
        String template = TemplateUtils.loadTemplate(resource, version, versionProperty);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, template);){
            map.put(templateName, IndexTemplateMetadata.Builder.fromXContent((XContentParser)parser, (String)templateName));
        }
        catch (IOException e) {
            logger.error("Error loading template [{}] as part of metadata upgrading", (Object)templateName);
        }
    }

    public static String loadTemplate(String resource, String version, String versionProperty) {
        return TemplateUtils.loadTemplate(resource, version, versionProperty, Collections.emptyMap());
    }

    public static String loadTemplate(String resource, String version, String versionProperty, Map<String, String> variables) {
        try {
            String source = TemplateUtils.load(resource);
            source = TemplateUtils.replaceVariables(source, version, versionProperty, variables);
            TemplateUtils.validate(source);
            return source;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load template [" + resource + "]", e);
        }
    }

    public static String load(String name) throws IOException {
        return Streams.readFully((InputStream)TemplateUtils.class.getResourceAsStream(name)).utf8ToString();
    }

    public static void validate(String source) {
        if (source == null) {
            throw new ElasticsearchParseException("Template must not be null", new Object[0]);
        }
        if (Strings.isEmpty((CharSequence)source)) {
            throw new ElasticsearchParseException("Template must not be empty", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)source, (boolean)false);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid template", (Throwable)e, new Object[0]);
        }
    }

    private static String replaceVariables(String input, String version, String versionProperty, Map<String, String> variables) {
        String template = TemplateUtils.replaceVariable(input, versionProperty, version);
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            template = TemplateUtils.replaceVariable(template, variable.getKey(), variable.getValue());
        }
        return template;
    }

    public static String replaceVariable(String input, String variable, String value) {
        return Pattern.compile("${" + variable + "}", 16).matcher(input).replaceAll(value);
    }

    public static boolean checkTemplateExistsAndVersionIsGTECurrentVersion(String templateName, ClusterState state) {
        IndexTemplateMetadata templateMetadata = (IndexTemplateMetadata)state.metadata().templates().get((Object)templateName);
        if (templateMetadata == null) {
            return false;
        }
        return templateMetadata.version() != null && templateMetadata.version() >= Version.CURRENT.id;
    }

    public static boolean checkTemplateExistsAndIsUpToDate(String templateName, String versionKey, ClusterState state, Logger logger) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches(templateName, versionKey, state, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, String versionKey, ClusterState state, Logger logger, Predicate<Version> predicate) {
        IndexTemplateMetadata templateMeta = (IndexTemplateMetadata)state.metadata().templates().get((Object)templateName);
        if (templateMeta == null) {
            return false;
        }
        ImmutableOpenMap mappings = templateMeta.getMappings();
        for (Object typeMapping : mappings.values().toArray()) {
            CompressedXContent typeMappingXContent = (CompressedXContent)typeMapping;
            try {
                Map typeMappingMap = (Map)XContentHelper.convertToMap((BytesReference)typeMappingXContent.uncompressed(), (boolean)false, (XContentType)XContentType.JSON).v2();
                assert (typeMappingMap.size() == 1);
                String key = (String)typeMappingMap.keySet().iterator().next();
                Map mappingMap = (Map)typeMappingMap.get(key);
                if (TemplateUtils.containsCorrectVersion(versionKey, mappingMap, predicate)) continue;
                return false;
            }
            catch (ElasticsearchParseException e) {
                logger.error((Message)new ParameterizedMessage("Cannot parse the template [{}]", (Object)templateName), (Throwable)e);
                throw new IllegalStateException("Cannot parse the template " + templateName, e);
            }
        }
        return true;
    }

    private static boolean containsCorrectVersion(String versionKey, Map<String, Object> typeMappingMap, Predicate<Version> predicate) {
        Map meta = (Map)typeMappingMap.get("_meta");
        if (meta == null) {
            return false;
        }
        return predicate.test(Version.fromString((String)((String)meta.get(versionKey))));
    }
}

