/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.history;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.slm.history.SnapshotHistoryItem;

public class SnapshotHistoryStore {
    private static final Logger logger = LogManager.getLogger(SnapshotHistoryStore.class);
    public static final String SLM_HISTORY_INDEX_PREFIX = ".slm-history-3-";
    public static final String SLM_HISTORY_ALIAS = ".slm-history-3";
    private final Client client;
    private final ClusterService clusterService;
    private final boolean slmHistoryEnabled;

    public SnapshotHistoryStore(Settings nodeSettings, Client client, ClusterService clusterService) {
        this.client = client;
        this.clusterService = clusterService;
        this.slmHistoryEnabled = (Boolean)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.get(nodeSettings);
    }

    public void putAsync(SnapshotHistoryItem item) {
        if (!this.slmHistoryEnabled) {
            logger.trace("not recording snapshot history item because [{}] is [false]: [{}]", (Object)LifecycleSettings.SLM_HISTORY_INDEX_ENABLED_SETTING.getKey(), (Object)item);
            return;
        }
        logger.trace("about to index snapshot history item in index [{}]: [{}]", (Object)SLM_HISTORY_ALIAS, (Object)item);
        SnapshotHistoryStore.ensureHistoryIndex(this.client, this.clusterService.state(), (ActionListener<Boolean>)ActionListener.wrap(createdIndex -> {
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                item.toXContent(builder, ToXContent.EMPTY_PARAMS);
                IndexRequest request = new IndexRequest(SLM_HISTORY_ALIAS).source(builder);
                this.client.index(request, ActionListener.wrap(indexResponse -> logger.debug("successfully indexed snapshot history item with id [{}] in index [{}]: [{}]", (Object)indexResponse.getId(), (Object)SLM_HISTORY_ALIAS, (Object)item), exception -> logger.error((Message)new ParameterizedMessage("failed to index snapshot history item in index [{}]: [{}]", (Object)SLM_HISTORY_ALIAS, (Object)item), (Throwable)exception)));
            }
            catch (IOException exception2) {
                logger.error((Message)new ParameterizedMessage("failed to index snapshot history item in index [{}]: [{}]", (Object)SLM_HISTORY_ALIAS, (Object)item), (Throwable)exception2);
            }
        }, ex -> logger.error((Message)new ParameterizedMessage("failed to ensure SLM history index exists, not indexing history item [{}]", (Object)item), (Throwable)ex)));
    }

    static void ensureHistoryIndex(Client client, ClusterState state, final ActionListener<Boolean> andThen) {
        String initialHistoryIndexName = ".slm-history-3-000001";
        IndexAbstraction slmHistory = (IndexAbstraction)state.metadata().getIndicesLookup().get(SLM_HISTORY_ALIAS);
        IndexAbstraction initialHistoryIndex = (IndexAbstraction)state.metadata().getIndicesLookup().get(".slm-history-3-000001");
        if (slmHistory == null && initialHistoryIndex == null) {
            client.admin().indices().prepareCreate(".slm-history-3-000001").setWaitForActiveShards(1).addAlias(new Alias(SLM_HISTORY_ALIAS).writeIndex(Boolean.valueOf(true)).isHidden(Boolean.valueOf(true))).execute((ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse response) {
                    andThen.onResponse((Object)true);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        logger.debug("index [{}] was created after checking for its existence, likely due to a concurrent call", (Object)".slm-history-3-000001");
                        andThen.onResponse((Object)false);
                    } else {
                        andThen.onFailure(e);
                    }
                }
            });
        } else if (slmHistory == null) {
            andThen.onFailure((Exception)new IllegalStateException("SLM history index [.slm-history-3-000001] already exists but does not have alias [.slm-history-3]"));
        } else if (slmHistory.getType() == IndexAbstraction.Type.ALIAS) {
            if (slmHistory.getWriteIndex() != null) {
                andThen.onResponse((Object)false);
            } else {
                andThen.onFailure((Exception)new IllegalStateException("SLM history alias [.slm-history-3does not have a write index"));
            }
        } else if (slmHistory.getType() != IndexAbstraction.Type.ALIAS) {
            andThen.onFailure((Exception)new IllegalStateException("SLM history alias [.slm-history-3] already exists as " + slmHistory.getType().getDisplayName()));
        } else {
            logger.error("unexpected IndexOrAlias for [{}]: [{}]", (Object)SLM_HISTORY_ALIAS, (Object)slmHistory);
            assert (false) : ".slm-history-3 cannot be both an alias and not an alias simultaneously";
        }
    }
}

