/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.core.security.user.User;

public final class DocumentPermissions {
    private final Set<BytesReference> queries;
    private final Set<BytesReference> limitedByQueries;
    private static DocumentPermissions ALLOW_ALL = new DocumentPermissions();

    DocumentPermissions() {
        this.queries = null;
        this.limitedByQueries = null;
    }

    DocumentPermissions(Set<BytesReference> queries) {
        this(queries, null);
    }

    DocumentPermissions(Set<BytesReference> queries, Set<BytesReference> scopedByQueries) {
        if (queries == null && scopedByQueries == null) {
            throw new IllegalArgumentException("one of the queries or scoped queries must be provided");
        }
        this.queries = queries != null ? Collections.unmodifiableSet(queries) : queries;
        this.limitedByQueries = scopedByQueries != null ? Collections.unmodifiableSet(scopedByQueries) : scopedByQueries;
    }

    public Set<BytesReference> getQueries() {
        return this.queries;
    }

    public Set<BytesReference> getLimitedByQueries() {
        return this.limitedByQueries;
    }

    public boolean hasDocumentLevelPermissions() {
        return this.queries != null || this.limitedByQueries != null;
    }

    public BooleanQuery filter(User user, ScriptService scriptService, ShardId shardId, Function<ShardId, QueryShardContext> queryShardContextProvider) throws IOException {
        if (this.hasDocumentLevelPermissions()) {
            BooleanQuery.Builder filter;
            if (this.queries != null && this.limitedByQueries != null) {
                filter = new BooleanQuery.Builder();
                BooleanQuery.Builder scopedFilter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.limitedByQueries, scopedFilter);
                filter.add((Query)scopedFilter.build(), BooleanClause.Occur.FILTER);
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.queries, filter);
            } else if (this.queries != null) {
                filter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.queries, filter);
            } else if (this.limitedByQueries != null) {
                filter = new BooleanQuery.Builder();
                DocumentPermissions.buildRoleQuery(user, scriptService, shardId, queryShardContextProvider, this.limitedByQueries, filter);
            } else {
                return null;
            }
            return filter.build();
        }
        return null;
    }

    private static void buildRoleQuery(User user, ScriptService scriptService, ShardId shardId, Function<ShardId, QueryShardContext> queryShardContextProvider, Set<BytesReference> queries, BooleanQuery.Builder filter) throws IOException {
        for (BytesReference bytesReference : queries) {
            QueryShardContext queryShardContext;
            QueryBuilder queryBuilder = DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(bytesReference, scriptService, (queryShardContext = queryShardContextProvider.apply(shardId)).getXContentRegistry(), user);
            if (queryBuilder == null) continue;
            DocumentPermissions.failIfQueryUsesClient(queryBuilder, (QueryRewriteContext)queryShardContext);
            Query roleQuery = queryShardContext.toQuery(queryBuilder).query();
            filter.add(roleQuery, BooleanClause.Occur.SHOULD);
            if (!queryShardContext.getMapperService().hasNested()) continue;
            NestedHelper nestedHelper = new NestedHelper(queryShardContext.getMapperService());
            if (nestedHelper.mightMatchNestedDocs(roleQuery)) {
                roleQuery = new BooleanQuery.Builder().add(roleQuery, BooleanClause.Occur.FILTER).add(Queries.newNonNestedFilter((Version)queryShardContext.indexVersionCreated()), BooleanClause.Occur.FILTER).build();
            }
            BitSetProducer rootDocs = queryShardContext.bitsetFilter(Queries.newNonNestedFilter((Version)queryShardContext.indexVersionCreated()));
            ToChildBlockJoinQuery includeNestedDocs = new ToChildBlockJoinQuery(roleQuery, rootDocs);
            filter.add((Query)includeNestedDocs, BooleanClause.Occur.SHOULD);
        }
        filter.setMinimumNumberShouldMatch(1);
    }

    static void failIfQueryUsesClient(QueryBuilder queryBuilder, QueryRewriteContext original) throws IOException {
        QueryRewriteContext copy = new QueryRewriteContext(original.getXContentRegistry(), original.getWriteableRegistry(), null, () -> ((QueryRewriteContext)original).nowInMillis());
        Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)copy);
        if (copy.hasAsyncActions()) {
            throw new IllegalStateException("role queries are not allowed to execute additional requests");
        }
    }

    public static DocumentPermissions filteredBy(Set<BytesReference> queries) {
        if (queries == null || queries.isEmpty()) {
            throw new IllegalArgumentException("null or empty queries not permitted");
        }
        return new DocumentPermissions(queries);
    }

    public static DocumentPermissions allowAll() {
        return ALLOW_ALL;
    }

    public DocumentPermissions limitDocumentPermissions(DocumentPermissions limitedByDocumentPermissions) {
        assert (this.limitedByQueries == null && limitedByDocumentPermissions.limitedByQueries == null) : "nested scoping for document permissions is not permitted";
        if (this.queries == null && limitedByDocumentPermissions.queries == null) {
            return DocumentPermissions.allowAll();
        }
        return new DocumentPermissions(this.queries, limitedByDocumentPermissions.queries);
    }

    public String toString() {
        return "DocumentPermissions [queries=" + this.queries + ", scopedByQueries=" + this.limitedByQueries + "]";
    }
}

