/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class SearchableSnapshotFeatureSetUsage
extends XPackFeatureSet.Usage {
    private final int numberOfSearchableSnapshotIndices;

    public SearchableSnapshotFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        this.numberOfSearchableSnapshotIndices = input.readVInt();
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_7_9_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.numberOfSearchableSnapshotIndices);
    }

    public SearchableSnapshotFeatureSetUsage(boolean available, int numberOfSearchableSnapshotIndices) {
        super("searchable_snapshots", available, true);
        this.numberOfSearchableSnapshotIndices = numberOfSearchableSnapshotIndices;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field("indices_count", this.numberOfSearchableSnapshotIndices);
    }

    public int getNumberOfSearchableSnapshotIndices() {
        return this.numberOfSearchableSnapshotIndices;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.numberOfSearchableSnapshotIndices);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchableSnapshotFeatureSetUsage other = (SearchableSnapshotFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.numberOfSearchableSnapshotIndices, other.numberOfSearchableSnapshotIndices);
    }
}

