/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.util.Collection;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollController;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.search.action.ClosePointInTimeRequest;
import org.elasticsearch.xpack.core.search.action.ClosePointInTimeResponse;

public class TransportClosePointInTimeAction
extends HandledTransportAction<ClosePointInTimeRequest, ClosePointInTimeResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final NamedWriteableRegistry namedWriteableRegistry;

    @Inject
    public TransportClosePointInTimeAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, NamedWriteableRegistry namedWriteableRegistry) {
        super("indices:data/read/close_point_in_time", transportService, actionFilters, ClosePointInTimeRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    protected void doExecute(Task task, ClosePointInTimeRequest request, ActionListener<ClosePointInTimeResponse> listener) {
        SearchContextId searchContextId = SearchContextId.decode((NamedWriteableRegistry)this.namedWriteableRegistry, (String)request.getId());
        Collection contextIds = searchContextId.shards().values();
        ClearScrollController.closeContexts((DiscoveryNodes)this.clusterService.state().nodes(), (SearchTransportService)this.searchTransportService, contextIds, (ActionListener)ActionListener.map(listener, freed -> new ClosePointInTimeResponse(freed.intValue() == contextIds.size(), (int)freed)));
    }
}

