/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.xpack.core.search.action.ClosePointInTimeAction;
import org.elasticsearch.xpack.core.search.action.ClosePointInTimeRequest;

public class RestClosePointInTimeAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.DELETE, "/_pit"));
    }

    public String getName() {
        return "close_point_in_time";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClosePointInTimeRequest clearRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            clearRequest = ClosePointInTimeRequest.fromXContent(parser);
        }
        return channel -> client.execute((ActionType)ClosePointInTimeAction.INSTANCE, (ActionRequest)clearRequest, (ActionListener)new RestStatusToXContentListener(channel));
    }
}

