/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.search.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class OpenPointInTimeResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField ID = new ParseField("id", new String[0]);
    private final String searchContextId;

    public OpenPointInTimeResponse(String searchContextId) {
        this.searchContextId = Objects.requireNonNull(searchContextId);
    }

    public OpenPointInTimeResponse(StreamInput in) throws IOException {
        super(in);
        this.searchContextId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.searchContextId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.searchContextId);
        builder.endObject();
        return builder;
    }

    public String getSearchContextId() {
        return this.searchContextId;
    }
}

