/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.indexing.IndexerState;

public class RollupJobStatus
implements Task.Status,
PersistentTaskState {
    public static final String NAME = "xpack/rollup/job";
    private final IndexerState state;
    @Nullable
    private final TreeMap<String, Object> currentPosition;
    private boolean upgradedDocumentID;
    private static final ParseField STATE = new ParseField("job_state", new String[0]);
    private static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    private static final ParseField UPGRADED_DOC_ID = new ParseField("upgraded_doc_id", new String[0]);
    public static final ConstructingObjectParser<RollupJobStatus, Void> PARSER = new ConstructingObjectParser("xpack/rollup/job", args -> new RollupJobStatus((IndexerState)((Object)((Object)args[0])), (HashMap)args[1], (Boolean)args[2]));

    public RollupJobStatus(IndexerState state, @Nullable Map<String, Object> position, @Nullable Boolean upgradedDocumentID) {
        this.state = state;
        this.currentPosition = position == null ? null : new TreeMap<String, Object>(position);
        this.upgradedDocumentID = upgradedDocumentID != null ? upgradedDocumentID : false;
    }

    public RollupJobStatus(StreamInput in) throws IOException {
        this.state = IndexerState.fromStream(in);
        this.currentPosition = in.readBoolean() ? new TreeMap(in.readMap()) : null;
        this.upgradedDocumentID = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readBoolean() : false;
    }

    public IndexerState getIndexerState() {
        return this.state;
    }

    public Map<String, Object> getPosition() {
        return this.currentPosition;
    }

    public boolean isUpgradedDocumentID() {
        return this.upgradedDocumentID;
    }

    public static RollupJobStatus fromXContent(XContentParser parser) {
        try {
            return (RollupJobStatus)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATE.getPreferredName(), this.state.value());
        if (this.currentPosition != null) {
            builder.field(CURRENT_POSITION.getPreferredName(), this.currentPosition);
        }
        builder.field(UPGRADED_DOC_ID.getPreferredName(), this.upgradedDocumentID);
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.state.writeTo(out);
        out.writeBoolean(this.currentPosition != null);
        if (this.currentPosition != null) {
            out.writeMap(this.currentPosition);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeBoolean(this.upgradedDocumentID);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobStatus that = (RollupJobStatus)other;
        return Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.currentPosition, that.currentPosition) && Objects.equals(this.upgradedDocumentID, that.upgradedDocumentID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.currentPosition, this.upgradedDocumentID});
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), IndexerState::fromString, STATE);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                return p.map();
            }
            if (p.currentToken() == XContentParser.Token.VALUE_NULL) {
                return null;
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, CURRENT_POSITION, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), UPGRADED_DOC_ID);
    }
}

