/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.exporter;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public final class MonitoringTemplateUtils {
    private static final String TEMPLATE_FILE = "/monitoring-%s.json";
    private static final String TEMPLATE_VERSION_PROPERTY = "monitoring.template.version";
    public static final int LAST_UPDATED_VERSION = Version.V_7_0_1.id;
    public static final String TEMPLATE_VERSION = "7";
    public static final String OLD_TEMPLATE_VERSION = "6";
    public static final String[] TEMPLATE_IDS = new String[]{"alerts-7", "es", "kibana", "logstash", "beats"};
    public static final String[] OLD_TEMPLATE_IDS = new String[]{"data", "es", "kibana", "logstash"};
    public static final String[] PIPELINE_IDS = new String[]{"7", "6"};

    private MonitoringTemplateUtils() {
    }

    public static String templateName(String id) {
        return ".monitoring-" + id;
    }

    public static String oldTemplateName(String id) {
        return ".monitoring-" + id + "-" + OLD_TEMPLATE_VERSION;
    }

    public static String loadTemplate(String id) {
        String resource = String.format(Locale.ROOT, TEMPLATE_FILE, id);
        return TemplateUtils.loadTemplate(resource, TEMPLATE_VERSION, TEMPLATE_VERSION_PROPERTY);
    }

    public static String createEmptyTemplate(String id) {
        return "{\"index_patterns\":[\".monitoring-" + id + "-" + OLD_TEMPLATE_VERSION + "*\"],\"version\":" + LAST_UPDATED_VERSION + "}";
    }

    public static String pipelineName(String id) {
        return "xpack_monitoring_" + id;
    }

    public static XContentBuilder loadPipeline(String id, XContentType type) {
        switch (id) {
            case "7": {
                return MonitoringTemplateUtils.emptyPipeline(type);
            }
            case "6": {
                return MonitoringTemplateUtils.pipelineForApiVersion6(type);
            }
        }
        throw new IllegalArgumentException("unrecognized pipeline API version [" + id + "]");
    }

    static XContentBuilder pipelineForApiVersion6(XContentType type) {
        try {
            return XContentBuilder.builder((XContent)type.xContent()).startObject().field("description", "This pipeline upgrades documents from the older version of the Monitoring API to the newer version (7) by fixing breaking changes in those older documents before they are indexed from the older version (6).").field("version", LAST_UPDATED_VERSION).startArray("processors").startObject().startObject("script").field("source", "ctx._type = null").endObject().endObject().startObject().startObject("gsub").field("field", "_index").field("pattern", "(.monitoring-\\w+-)6(-.+)").field("replacement", "$17$2").endObject().endObject().endArray().endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create pipeline to upgrade from older version [6] to the newer version [7].", e);
        }
    }

    public static XContentBuilder emptyPipeline(XContentType type) {
        try {
            return XContentBuilder.builder((XContent)type.xContent()).startObject().field("description", "This is a placeholder pipeline for Monitoring API version 7 so that future versions may fix breaking changes.").field("version", LAST_UPDATED_VERSION).startArray("processors").endArray().endObject();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create empty pipeline", e);
        }
    }

    public static String indexName(DateFormatter formatter, MonitoredSystem system, long timestamp) {
        return ".monitoring-" + system.getSystem() + "-" + TEMPLATE_VERSION + "-" + formatter.format((TemporalAccessor)Instant.ofEpochMilli(timestamp));
    }
}

