/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;

public class TotalFeatureImportance
implements ToXContentObject,
Writeable {
    private static final String NAME = "total_feature_importance";
    public static final ParseField FEATURE_NAME = new ParseField("feature_name", new String[0]);
    public static final ParseField IMPORTANCE = new ParseField("importance", new String[0]);
    public static final ParseField CLASSES = new ParseField("classes", new String[0]);
    public static final ParseField MEAN_MAGNITUDE = new ParseField("mean_magnitude", new String[0]);
    public static final ParseField MIN = new ParseField("min", new String[0]);
    public static final ParseField MAX = new ParseField("max", new String[0]);
    public static final ConstructingObjectParser<TotalFeatureImportance, Void> LENIENT_PARSER = TotalFeatureImportance.createParser(true);
    public static final ConstructingObjectParser<TotalFeatureImportance, Void> STRICT_PARSER = TotalFeatureImportance.createParser(false);
    public final String featureName;
    public final Importance importance;
    public final List<ClassImportance> classImportances;

    private static ConstructingObjectParser<TotalFeatureImportance, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new TotalFeatureImportance((String)a[0], (Importance)a[1], (List)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), FEATURE_NAME);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), ignoreUnknownFields ? Importance.LENIENT_PARSER : Importance.STRICT_PARSER, IMPORTANCE);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), ignoreUnknownFields ? ClassImportance.LENIENT_PARSER : ClassImportance.STRICT_PARSER, CLASSES);
        return parser;
    }

    public static TotalFeatureImportance fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (TotalFeatureImportance)LENIENT_PARSER.parse(parser, null) : (TotalFeatureImportance)STRICT_PARSER.parse(parser, null);
    }

    public TotalFeatureImportance(StreamInput in) throws IOException {
        this.featureName = in.readString();
        this.importance = (Importance)in.readOptionalWriteable(Importance::new);
        this.classImportances = in.readList(ClassImportance::new);
    }

    TotalFeatureImportance(String featureName, @Nullable Importance importance, @Nullable List<ClassImportance> classImportances) {
        this.featureName = featureName;
        this.importance = importance;
        this.classImportances = classImportances == null ? Collections.emptyList() : classImportances;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeOptionalWriteable((Writeable)this.importance);
        out.writeList(this.classImportances);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.asMap());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TotalFeatureImportance that = (TotalFeatureImportance)o;
        return Objects.equals(that.importance, this.importance) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.classImportances, that.classImportances);
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(FEATURE_NAME.getPreferredName(), this.featureName);
        if (this.importance != null) {
            map.put(IMPORTANCE.getPreferredName(), this.importance.asMap());
        }
        if (!this.classImportances.isEmpty()) {
            map.put(CLASSES.getPreferredName(), this.classImportances.stream().map(rec$ -> ((ClassImportance)rec$).asMap()).collect(Collectors.toList()));
        }
        return map;
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.importance, this.classImportances);
    }

    public static class Importance
    implements ToXContentObject,
    Writeable {
        private static final String NAME = "importance";
        public static final ConstructingObjectParser<Importance, Void> LENIENT_PARSER = Importance.createParser(true);
        public static final ConstructingObjectParser<Importance, Void> STRICT_PARSER = Importance.createParser(false);
        private final double meanMagnitude;
        private final double min;
        private final double max;

        private static ConstructingObjectParser<Importance, Void> createParser(boolean ignoreUnknownFields) {
            ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new Importance((Double)a[0], (Double)a[1], (Double)a[2]));
            parser.declareDouble(ConstructingObjectParser.constructorArg(), MEAN_MAGNITUDE);
            parser.declareDouble(ConstructingObjectParser.constructorArg(), MIN);
            parser.declareDouble(ConstructingObjectParser.constructorArg(), MAX);
            return parser;
        }

        public Importance(double meanMagnitude, double min, double max) {
            this.meanMagnitude = meanMagnitude;
            this.min = min;
            this.max = max;
        }

        public Importance(StreamInput in) throws IOException {
            this.meanMagnitude = in.readDouble();
            this.min = in.readDouble();
            this.max = in.readDouble();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Importance that = (Importance)o;
            return Double.compare(that.meanMagnitude, this.meanMagnitude) == 0 && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.meanMagnitude, this.min, this.max);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.meanMagnitude);
            out.writeDouble(this.min);
            out.writeDouble(this.max);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.asMap());
        }

        private Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(MEAN_MAGNITUDE.getPreferredName(), this.meanMagnitude);
            map.put(MIN.getPreferredName(), this.min);
            map.put(MAX.getPreferredName(), this.max);
            return map;
        }
    }

    public static class ClassImportance
    implements ToXContentObject,
    Writeable {
        private static final String NAME = "total_class_importance";
        public static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
        public static final ParseField IMPORTANCE = new ParseField("importance", new String[0]);
        public static final ConstructingObjectParser<ClassImportance, Void> LENIENT_PARSER = ClassImportance.createParser(true);
        public static final ConstructingObjectParser<ClassImportance, Void> STRICT_PARSER = ClassImportance.createParser(false);
        public final Object className;
        public final Importance importance;

        private static ConstructingObjectParser<ClassImportance, Void> createParser(boolean ignoreUnknownFields) {
            ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new ClassImportance(a[0], (Importance)a[1]));
            parser.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.numberValue();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                    return Boolean.valueOf(p.booleanValue());
                }
                throw new XContentParseException("Unsupported token [" + p.currentToken() + "]");
            }, CLASS_NAME, ObjectParser.ValueType.VALUE);
            parser.declareObject(ConstructingObjectParser.constructorArg(), ignoreUnknownFields ? Importance.LENIENT_PARSER : Importance.STRICT_PARSER, IMPORTANCE);
            return parser;
        }

        public static ClassImportance fromXContent(XContentParser parser, boolean lenient) throws IOException {
            return lenient ? (ClassImportance)LENIENT_PARSER.parse(parser, null) : (ClassImportance)STRICT_PARSER.parse(parser, null);
        }

        public ClassImportance(StreamInput in) throws IOException {
            this.className = in.readGenericValue();
            this.importance = new Importance(in);
        }

        ClassImportance(Object className, Importance importance) {
            this.className = className;
            this.importance = importance;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.className);
            this.importance.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.asMap());
        }

        private Map<String, Object> asMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(CLASS_NAME.getPreferredName(), this.className);
            map.put(IMPORTANCE.getPreferredName(), this.importance.asMap());
            return map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassImportance that = (ClassImportance)o;
            return Objects.equals(that.importance, this.importance) && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.importance);
        }
    }
}

