/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.results.AbstractFeatureImportance;

public class RegressionFeatureImportance
extends AbstractFeatureImportance {
    private final double importance;
    private final String featureName;
    static final String IMPORTANCE = "importance";
    static final String FEATURE_NAME = "feature_name";
    private static final ConstructingObjectParser<RegressionFeatureImportance, Void> PARSER = new ConstructingObjectParser("regression_feature_importance", a -> new RegressionFeatureImportance((String)a[0], (Double)a[1]));

    public static RegressionFeatureImportance fromXContent(XContentParser parser) {
        return (RegressionFeatureImportance)PARSER.apply(parser, null);
    }

    public RegressionFeatureImportance(String featureName, double importance) {
        this.featureName = Objects.requireNonNull(featureName);
        this.importance = importance;
    }

    public RegressionFeatureImportance(StreamInput in) throws IOException {
        this.featureName = in.readString();
        this.importance = in.readDouble();
    }

    public double getImportance() {
        return this.importance;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeDouble(this.importance);
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(FEATURE_NAME, this.featureName);
        map.put(IMPORTANCE, this.importance);
        return map;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RegressionFeatureImportance that = (RegressionFeatureImportance)object;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.importance, that.importance);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.importance);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FEATURE_NAME, new String[0]));
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), new ParseField(IMPORTANCE, new String[0]));
    }
}

