/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.annotations;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class Annotation
implements ToXContentObject,
Writeable {
    public static final ParseField RESULTS_FIELD = new ParseField("annotation", new String[0]);
    public static final ParseField ANNOTATION = new ParseField("annotation", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField CREATE_USERNAME = new ParseField("create_username", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField END_TIMESTAMP = new ParseField("end_timestamp", new String[0]);
    public static final ParseField MODIFIED_TIME = new ParseField("modified_time", new String[0]);
    public static final ParseField MODIFIED_USERNAME = new ParseField("modified_username", new String[0]);
    public static final ParseField TYPE = new ParseField("type", new String[0]);
    public static final ParseField EVENT = new ParseField("event", new String[0]);
    public static final ParseField DETECTOR_INDEX = new ParseField("detector_index", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField OVER_FIELD_NAME = new ParseField("over_field_name", new String[0]);
    public static final ParseField OVER_FIELD_VALUE = new ParseField("over_field_value", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = new ObjectParser(RESULTS_FIELD.getPreferredName(), false, Builder::new);
    private final String annotation;
    private final Date createTime;
    private final String createUsername;
    private final Date timestamp;
    private final Date endTimestamp;
    private final String jobId;
    private final Date modifiedTime;
    private final String modifiedUsername;
    private final Type type;
    private final Event event;
    private final Integer detectorIndex;
    private final String partitionFieldName;
    private final String partitionFieldValue;
    private final String overFieldName;
    private final String overFieldValue;
    private final String byFieldName;
    private final String byFieldValue;

    public static Annotation fromXContent(XContentParser parser, Void context) {
        return ((Builder)STRICT_PARSER.apply(parser, (Object)context)).build();
    }

    private Annotation(String annotation, Date createTime, String createUsername, Date timestamp, Date endTimestamp, String jobId, Date modifiedTime, String modifiedUsername, Type type, Event event, Integer detectorIndex, String partitionFieldName, String partitionFieldValue, String overFieldName, String overFieldValue, String byFieldName, String byFieldValue) {
        this.annotation = Objects.requireNonNull(annotation);
        this.createTime = Objects.requireNonNull(createTime);
        this.createUsername = Objects.requireNonNull(createUsername);
        this.timestamp = Objects.requireNonNull(timestamp);
        this.endTimestamp = endTimestamp;
        this.jobId = jobId;
        this.modifiedTime = modifiedTime;
        this.modifiedUsername = modifiedUsername;
        this.type = Objects.requireNonNull(type);
        this.event = event;
        this.detectorIndex = detectorIndex;
        this.partitionFieldName = partitionFieldName;
        this.partitionFieldValue = partitionFieldValue;
        this.overFieldName = overFieldName;
        this.overFieldValue = overFieldValue;
        this.byFieldName = byFieldName;
        this.byFieldValue = byFieldValue;
    }

    public Annotation(StreamInput in) throws IOException {
        this.annotation = in.readString();
        this.createTime = new Date(in.readLong());
        this.createUsername = in.readString();
        this.timestamp = new Date(in.readLong());
        this.endTimestamp = in.readBoolean() ? new Date(in.readLong()) : null;
        this.jobId = in.readOptionalString();
        this.modifiedTime = in.readBoolean() ? new Date(in.readLong()) : null;
        this.modifiedUsername = in.readOptionalString();
        this.type = Type.fromString(in.readString());
        if (in.getVersion().onOrAfter(Version.V_7_9_0)) {
            this.event = in.readBoolean() ? (Event)in.readEnum(Event.class) : null;
            this.detectorIndex = in.readOptionalInt();
            this.partitionFieldName = in.readOptionalString();
            this.partitionFieldValue = in.readOptionalString();
            this.overFieldName = in.readOptionalString();
            this.overFieldValue = in.readOptionalString();
            this.byFieldName = in.readOptionalString();
            this.byFieldValue = in.readOptionalString();
        } else {
            this.event = null;
            this.detectorIndex = null;
            this.partitionFieldName = null;
            this.partitionFieldValue = null;
            this.overFieldName = null;
            this.overFieldValue = null;
            this.byFieldName = null;
            this.byFieldValue = null;
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.annotation);
        out.writeLong(this.createTime.getTime());
        out.writeString(this.createUsername);
        out.writeLong(this.timestamp.getTime());
        if (this.endTimestamp != null) {
            out.writeBoolean(true);
            out.writeLong(this.endTimestamp.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.jobId);
        if (this.modifiedTime != null) {
            out.writeBoolean(true);
            out.writeLong(this.modifiedTime.getTime());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.modifiedUsername);
        out.writeString(this.type.toString());
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            if (this.event != null) {
                out.writeBoolean(true);
                out.writeEnum((Enum)this.event);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalInt(this.detectorIndex);
            out.writeOptionalString(this.partitionFieldName);
            out.writeOptionalString(this.partitionFieldValue);
            out.writeOptionalString(this.overFieldName);
            out.writeOptionalString(this.overFieldValue);
            out.writeOptionalString(this.byFieldName);
            out.writeOptionalString(this.byFieldValue);
        }
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreateUsername() {
        return this.createUsername;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Date getEndTimestamp() {
        return this.endTimestamp;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public String getModifiedUsername() {
        return this.modifiedUsername;
    }

    public Type getType() {
        return this.type;
    }

    public Event getEvent() {
        return this.event;
    }

    public Integer getDetectorIndex() {
        return this.detectorIndex;
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public String getOverFieldValue() {
        return this.overFieldValue;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ANNOTATION.getPreferredName(), this.annotation);
        builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.getTime());
        builder.field(CREATE_USERNAME.getPreferredName(), this.createUsername);
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        if (this.endTimestamp != null) {
            builder.timeField(END_TIMESTAMP.getPreferredName(), END_TIMESTAMP.getPreferredName() + "_string", this.endTimestamp.getTime());
        }
        if (this.jobId != null) {
            builder.field(Job.ID.getPreferredName(), this.jobId);
        }
        if (this.modifiedTime != null) {
            builder.timeField(MODIFIED_TIME.getPreferredName(), MODIFIED_TIME.getPreferredName() + "_string", this.modifiedTime.getTime());
        }
        if (this.modifiedUsername != null) {
            builder.field(MODIFIED_USERNAME.getPreferredName(), this.modifiedUsername);
        }
        builder.field(TYPE.getPreferredName(), (Object)this.type);
        if (this.event != null) {
            builder.field(EVENT.getPreferredName(), (Object)this.event);
        }
        if (this.detectorIndex != null) {
            builder.field(DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME.getPreferredName(), this.overFieldName);
        }
        if (this.overFieldValue != null) {
            builder.field(OVER_FIELD_VALUE.getPreferredName(), this.overFieldValue);
        }
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotation, this.createTime, this.createUsername, this.timestamp, this.endTimestamp, this.jobId, this.modifiedTime, this.modifiedUsername, this.type, this.event, this.detectorIndex, this.partitionFieldName, this.partitionFieldValue, this.overFieldName, this.overFieldValue, this.byFieldName, this.byFieldValue});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return Objects.equals(this.annotation, other.annotation) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.createUsername, other.createUsername) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.endTimestamp, other.endTimestamp) && Objects.equals(this.jobId, other.jobId) && Objects.equals(this.modifiedTime, other.modifiedTime) && Objects.equals(this.modifiedUsername, other.modifiedUsername) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.event, (Object)other.event) && Objects.equals(this.detectorIndex, other.detectorIndex) && Objects.equals(this.partitionFieldName, other.partitionFieldName) && Objects.equals(this.partitionFieldValue, other.partitionFieldValue) && Objects.equals(this.overFieldName, other.overFieldName) && Objects.equals(this.overFieldValue, other.overFieldValue) && Objects.equals(this.byFieldName, other.byFieldName) && Objects.equals(this.byFieldValue, other.byFieldValue);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        STRICT_PARSER.declareString(Builder::setAnnotation, ANNOTATION);
        STRICT_PARSER.declareField(Builder::setCreateTime, p -> TimeUtils.parseTimeField(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        STRICT_PARSER.declareString(Builder::setCreateUsername, CREATE_USERNAME);
        STRICT_PARSER.declareField(Builder::setTimestamp, p -> TimeUtils.parseTimeField(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        STRICT_PARSER.declareField(Builder::setEndTimestamp, p -> TimeUtils.parseTimeField(p, END_TIMESTAMP.getPreferredName()), END_TIMESTAMP, ObjectParser.ValueType.VALUE);
        STRICT_PARSER.declareString(Builder::setJobId, Job.ID);
        STRICT_PARSER.declareField(Builder::setModifiedTime, p -> TimeUtils.parseTimeField(p, MODIFIED_TIME.getPreferredName()), MODIFIED_TIME, ObjectParser.ValueType.VALUE);
        STRICT_PARSER.declareString(Builder::setModifiedUsername, MODIFIED_USERNAME);
        STRICT_PARSER.declareString(Builder::setType, Type::fromString, TYPE);
        STRICT_PARSER.declareString(Builder::setEvent, Event::fromString, EVENT);
        STRICT_PARSER.declareInt(Builder::setDetectorIndex, DETECTOR_INDEX);
        STRICT_PARSER.declareString(Builder::setPartitionFieldName, PARTITION_FIELD_NAME);
        STRICT_PARSER.declareString(Builder::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        STRICT_PARSER.declareString(Builder::setOverFieldName, OVER_FIELD_NAME);
        STRICT_PARSER.declareString(Builder::setOverFieldValue, OVER_FIELD_VALUE);
        STRICT_PARSER.declareString(Builder::setByFieldName, BY_FIELD_NAME);
        STRICT_PARSER.declareString(Builder::setByFieldValue, BY_FIELD_VALUE);
    }

    public static enum Type {
        ANNOTATION,
        COMMENT;


        public static Type fromString(String value) {
            return Type.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Event {
        USER,
        DELAYED_DATA,
        MODEL_SNAPSHOT_STORED,
        MODEL_CHANGE,
        CATEGORIZATION_STATUS_CHANGE;


        public static Event fromString(String value) {
            return Event.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Builder {
        private String annotation;
        private Date createTime;
        private String createUsername;
        private Date timestamp;
        private Date endTimestamp;
        private String jobId;
        private Date modifiedTime;
        private String modifiedUsername;
        private Type type;
        private Event event;
        private Integer detectorIndex;
        private String partitionFieldName;
        private String partitionFieldValue;
        private String overFieldName;
        private String overFieldValue;
        private String byFieldName;
        private String byFieldValue;

        public Builder() {
        }

        public Builder(Annotation other) {
            Objects.requireNonNull(other);
            this.annotation = other.annotation;
            this.createTime = new Date(other.createTime.getTime());
            this.createUsername = other.createUsername;
            this.timestamp = new Date(other.timestamp.getTime());
            this.endTimestamp = other.endTimestamp == null ? null : new Date(other.endTimestamp.getTime());
            this.jobId = other.jobId;
            this.modifiedTime = other.modifiedTime == null ? null : new Date(other.modifiedTime.getTime());
            this.modifiedUsername = other.modifiedUsername;
            this.type = other.type;
            this.event = other.event;
            this.detectorIndex = other.detectorIndex;
            this.partitionFieldName = other.partitionFieldName;
            this.partitionFieldValue = other.partitionFieldValue;
            this.overFieldName = other.overFieldName;
            this.overFieldValue = other.overFieldValue;
            this.byFieldName = other.byFieldName;
            this.byFieldValue = other.byFieldValue;
        }

        public Builder setAnnotation(String annotation) {
            this.annotation = Objects.requireNonNull(annotation);
            return this;
        }

        public Builder setCreateTime(Date createTime) {
            this.createTime = Objects.requireNonNull(createTime);
            return this;
        }

        public Builder setCreateUsername(String createUsername) {
            this.createUsername = Objects.requireNonNull(createUsername);
            return this;
        }

        public Builder setTimestamp(Date timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp);
            return this;
        }

        public Builder setEndTimestamp(Date endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Builder setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setModifiedTime(Date modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public Builder setModifiedUsername(String modifiedUsername) {
            this.modifiedUsername = modifiedUsername;
            return this;
        }

        public Builder setType(Type type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public Builder setEvent(Event event) {
            this.event = event;
            return this;
        }

        public Builder setDetectorIndex(Integer index) {
            this.detectorIndex = index;
            return this;
        }

        public Builder setPartitionFieldName(String name) {
            this.partitionFieldName = name;
            return this;
        }

        public Builder setPartitionFieldValue(String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public Builder setOverFieldName(String name) {
            this.overFieldName = name;
            return this;
        }

        public Builder setOverFieldValue(String value) {
            this.overFieldValue = value;
            return this;
        }

        public Builder setByFieldName(String name) {
            this.byFieldName = name;
            return this;
        }

        public Builder setByFieldValue(String value) {
            this.byFieldValue = value;
            return this;
        }

        public Annotation build() {
            return new Annotation(this.annotation, this.createTime, this.createUsername, this.timestamp, this.endTimestamp, this.jobId, this.modifiedTime, this.modifiedUsername, this.type, this.event, this.detectorIndex, this.partitionFieldName, this.partitionFieldValue, this.overFieldName, this.overFieldValue, this.byFieldName, this.byFieldValue);
        }
    }
}

