/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetCalendarEventsAction
extends ActionType<Response> {
    public static final GetCalendarEventsAction INSTANCE = new GetCalendarEventsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/calendars/events/get";

    private GetCalendarEventsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<ScheduledEvent>
    implements ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(QueryPage<ScheduledEvent> scheduledEvents) {
            super(scheduledEvents);
        }

        @Override
        protected Writeable.Reader<ScheduledEvent> getReader() {
            return ScheduledEvent::new;
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final ParseField START = new ParseField("start", new String[0]);
        public static final ParseField END = new ParseField("end", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/calendars/events/get", Request::new);
        private String calendarId;
        private String start;
        private String end;
        private String jobId;
        private PageParams pageParams = PageParams.defaultParams();

        public static Request parseRequest(String calendarId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (calendarId != null) {
                request.setCalendarId(calendarId);
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendarId = in.readString();
            this.start = in.readOptionalString();
            this.end = in.readOptionalString();
            this.jobId = in.readOptionalString();
            this.pageParams = new PageParams(in);
        }

        public Request(String calendarId) {
            this.setCalendarId(calendarId);
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        private void setCalendarId(String calendarId) {
            this.calendarId = ExceptionsHelper.requireNonNull(calendarId, Calendar.ID.getPreferredName());
        }

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public String getEnd() {
            return this.end;
        }

        public void setEnd(String end) {
            this.end = end;
        }

        public String getJobId() {
            return this.jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = Objects.requireNonNull(pageParams);
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException e = null;
            if (this.jobId != null && !Strings.isAllOrWildcard((String)this.calendarId)) {
                e = ValidateActions.addValidationError((String)("If " + Job.ID.getPreferredName() + " is used " + Calendar.ID.getPreferredName() + " must be '" + "_all" + "' or '*'"), e);
            }
            return e;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.calendarId);
            out.writeOptionalString(this.start);
            out.writeOptionalString(this.end);
            out.writeOptionalString(this.jobId);
            this.pageParams.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId, this.start, this.end, this.pageParams, this.jobId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.jobId, other.jobId);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Calendar.ID.getPreferredName(), this.calendarId);
            if (this.start != null) {
                builder.field(START.getPreferredName(), this.start);
            }
            if (this.end != null) {
                builder.field(END.getPreferredName(), this.end);
            }
            if (this.jobId != null) {
                builder.field(Job.ID.getPreferredName(), this.jobId);
            }
            builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(Request::setCalendarId, Calendar.ID);
            PARSER.declareString(Request::setStart, START);
            PARSER.declareString(Request::setEnd, END);
            PARSER.declareString(Request::setJobId, Job.ID);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
        }
    }
}

