/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;

class WaitForIndexColorStep
extends ClusterStateWaitStep {
    static final String NAME = "wait-for-index-color";
    private static final Logger logger = LogManager.getLogger(WaitForIndexColorStep.class);
    private final ClusterHealthStatus color;
    @Nullable
    private final String indexNamePrefix;

    WaitForIndexColorStep(Step.StepKey key, Step.StepKey nextStepKey, ClusterHealthStatus color) {
        this(key, nextStepKey, color, null);
    }

    WaitForIndexColorStep(Step.StepKey key, Step.StepKey nextStepKey, ClusterHealthStatus color, @Nullable String indexNamePrefix) {
        super(key, nextStepKey);
        this.color = color;
        this.indexNamePrefix = indexNamePrefix;
    }

    public ClusterHealthStatus getColor() {
        return this.color;
    }

    public String getIndexNamePrefix() {
        return this.indexNamePrefix;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.color, this.indexNamePrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        WaitForIndexColorStep other = (WaitForIndexColorStep)obj;
        return super.equals(obj) && Objects.equals(this.color, other.color) && Objects.equals(this.indexNamePrefix, other.indexNamePrefix);
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        ClusterStateWaitStep.Result result;
        String indexName = this.indexNamePrefix != null ? this.indexNamePrefix + index.getName() : index.getName();
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            String errorMessage = String.format(Locale.ROOT, "[%s] lifecycle action for index [%s] executed but index no longer exists", this.getKey().getAction(), indexName);
            logger.debug(errorMessage);
            return new ClusterStateWaitStep.Result(false, new Info(errorMessage));
        }
        IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(indexMetadata.getIndex());
        switch (this.color) {
            case GREEN: {
                result = this.waitForGreen(indexRoutingTable);
                break;
            }
            case YELLOW: {
                result = this.waitForYellow(indexRoutingTable);
                break;
            }
            case RED: {
                result = this.waitForRed(indexRoutingTable);
                break;
            }
            default: {
                result = new ClusterStateWaitStep.Result(false, new Info("no index color match"));
            }
        }
        return result;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    private ClusterStateWaitStep.Result waitForRed(IndexRoutingTable indexRoutingTable) {
        if (indexRoutingTable == null) {
            return new ClusterStateWaitStep.Result(true, new Info("index is red"));
        }
        return new ClusterStateWaitStep.Result(false, new Info("index is not red"));
    }

    private ClusterStateWaitStep.Result waitForYellow(IndexRoutingTable indexRoutingTable) {
        if (indexRoutingTable == null) {
            return new ClusterStateWaitStep.Result(false, new Info("index is red; no indexRoutingTable"));
        }
        boolean indexIsAtLeastYellow = indexRoutingTable.allPrimaryShardsActive();
        if (indexIsAtLeastYellow) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new Info("index is red; not all primary shards are active"));
    }

    private ClusterStateWaitStep.Result waitForGreen(IndexRoutingTable indexRoutingTable) {
        if (indexRoutingTable == null) {
            return new ClusterStateWaitStep.Result(false, new Info("index is red; no indexRoutingTable"));
        }
        if (indexRoutingTable.allPrimaryShardsActive()) {
            for (ObjectCursor shardRouting : indexRoutingTable.getShards().values()) {
                boolean replicaIndexIsGreen = ((IndexShardRoutingTable)shardRouting.value).replicaShards().stream().allMatch(ShardRouting::active);
                if (replicaIndexIsGreen) continue;
                return new ClusterStateWaitStep.Result(false, new Info("index is yellow; not all replica shards are active"));
            }
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new Info("index is not green; not all shards are active"));
    }

    static final class Info
    implements ToXContentObject {
        static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
        private final String message;

        Info(String message) {
            this.message = message;
        }

        String getMessage() {
            return this.message;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE_FIELD.getPreferredName(), this.message);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Objects.equals(this.getMessage(), info.getMessage());
        }

        public int hashCode() {
            return Objects.hash(this.getMessage());
        }
    }
}

