/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class ForgetFollowerAction
extends ActionType<BroadcastResponse> {
    public static final String NAME = "indices:admin/xpack/ccr/forget_follower";
    public static final ForgetFollowerAction INSTANCE = new ForgetFollowerAction();

    private ForgetFollowerAction() {
        super(NAME, BroadcastResponse::new);
    }

    public static class Request
    extends BroadcastRequest<Request> {
        private static final ParseField FOLLOWER_CLUSTER = new ParseField("follower_cluster", new String[0]);
        private static final ParseField FOLLOWER_INDEX = new ParseField("follower_index", new String[0]);
        private static final ParseField FOLLOWER_INDEX_UUID = new ParseField("follower_index_uuid", new String[0]);
        private static final ParseField LEADER_REMOTE_CLUSTER = new ParseField("leader_remote_cluster", new String[0]);
        private static final ObjectParser<String[], Void> PARSER = new ObjectParser("indices:admin/xpack/ccr/forget_follower", () -> new String[4]);
        private String followerCluster;
        private String followerIndex;
        private String followerIndexUUID;
        private String leaderRemoteCluster;
        private String leaderIndex;

        public static Request fromXContent(XContentParser parser, String leaderIndex) throws IOException {
            String[] parameters = (String[])PARSER.parse(parser, null);
            return new Request(parameters[0], parameters[1], parameters[2], parameters[3], leaderIndex);
        }

        public String followerCluster() {
            return this.followerCluster;
        }

        public String followerIndex() {
            return this.followerIndex;
        }

        public String followerIndexUUID() {
            return this.followerIndexUUID;
        }

        public String leaderRemoteCluster() {
            return this.leaderRemoteCluster;
        }

        public String leaderIndex() {
            return this.leaderIndex;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.followerCluster = in.readString();
            this.leaderIndex = in.readString();
            this.leaderRemoteCluster = in.readString();
            this.followerIndex = in.readString();
            this.followerIndexUUID = in.readString();
        }

        public Request(String followerCluster, String followerIndex, String followerIndexUUID, String leaderRemoteCluster, String leaderIndex) {
            super(new String[]{leaderIndex});
            this.followerCluster = Objects.requireNonNull(followerCluster);
            this.leaderIndex = Objects.requireNonNull(leaderIndex);
            this.leaderRemoteCluster = Objects.requireNonNull(leaderRemoteCluster);
            this.followerIndex = Objects.requireNonNull(followerIndex);
            this.followerIndexUUID = Objects.requireNonNull(followerIndexUUID);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.followerCluster);
            out.writeString(this.leaderIndex);
            out.writeString(this.leaderRemoteCluster);
            out.writeString(this.followerIndex);
            out.writeString(this.followerIndexUUID);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean includeDataStreams() {
            return false;
        }

        static {
            PARSER.declareString((parameters, value) -> {
                parameters[0] = value;
            }, FOLLOWER_CLUSTER);
            PARSER.declareString((parameters, value) -> {
                parameters[1] = value;
            }, FOLLOWER_INDEX);
            PARSER.declareString((parameters, value) -> {
                parameters[2] = value;
            }, FOLLOWER_INDEX_UUID);
            PARSER.declareString((parameters, value) -> {
                parameters[3] = value;
            }, LEADER_REMOTE_CLUSTER);
        }
    }
}

