/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.common.IteratingActionListener;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final List<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackUsageAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Set<XPackFeatureSet> featureSets) {
        super("cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, XPackUsageRequest::new, indexNameExpressionResolver);
        this.featureSets = Collections.unmodifiableList(new ArrayList<XPackFeatureSet>(featureSets));
    }

    protected String executor() {
        return "management";
    }

    protected XPackUsageResponse read(StreamInput in) throws IOException {
        return new XPackUsageResponse(in);
    }

    protected void masterOperation(XPackUsageRequest request, ClusterState state, final ActionListener<XPackUsageResponse> listener) {
        ActionListener<List<XPackFeatureSet.Usage>> usageActionListener = new ActionListener<List<XPackFeatureSet.Usage>>(){

            public void onResponse(List<XPackFeatureSet.Usage> usages) {
                listener.onResponse((Object)new XPackUsageResponse(usages));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        };
        final AtomicReferenceArray featureSetUsages = new AtomicReferenceArray(this.featureSets.size());
        final AtomicInteger position = new AtomicInteger(0);
        BiConsumer<XPackFeatureSet, ActionListener> consumer = (featureSet, iteratingListener) -> {
            assert (Transports.assertNotTransportThread((String)"calculating usage can be more expensive than we allow on transport threads"));
            featureSet.usage(new ActionListener<XPackFeatureSet.Usage>(){

                public void onResponse(XPackFeatureSet.Usage usage) {
                    featureSetUsages.set(position.getAndIncrement(), usage);
                    ActionRunnable invokeListener = ActionRunnable.supply((ActionListener)iteratingListener, Collections::emptyList);
                    TransportXPackUsageAction.this.threadPool.executor("management").execute((Runnable)invokeListener);
                }

                public void onFailure(Exception e) {
                    iteratingListener.onFailure(e);
                }
            });
        };
        IteratingActionListener<List, XPackFeatureSet> iteratingActionListener = new IteratingActionListener<List, XPackFeatureSet>(usageActionListener, consumer, this.featureSets, this.threadPool.getThreadContext(), ignore -> {
            ArrayList<XPackFeatureSet.Usage> usageList = new ArrayList<XPackFeatureSet.Usage>(featureSetUsages.length());
            for (int i = 0; i < featureSetUsages.length(); ++i) {
                usageList.add((XPackFeatureSet.Usage)featureSetUsages.get(i));
            }
            return usageList;
        }, ignore -> true);
        iteratingActionListener.run();
    }

    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

