/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.action.util.QueryPage;

public abstract class AbstractTransportGetResourcesAction<Resource extends ToXContent & Writeable, Request extends AbstractGetResourcesRequest, Response extends AbstractGetResourcesResponse<Resource>>
extends HandledTransportAction<Request, Response> {
    private static final String ALL = "_all";
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;

    protected AbstractTransportGetResourcesAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> request, Client client, NamedXContentRegistry xContentRegistry) {
        super(actionName, transportService, actionFilters, request);
        this.client = Objects.requireNonNull(client);
        this.xContentRegistry = Objects.requireNonNull(xContentRegistry);
    }

    protected void searchResources(final AbstractGetResourcesRequest request, final ActionListener<QueryPage<Resource>> listener) {
        final String[] tokens = Strings.tokenizeToStringArray((String)request.getResourceId(), (String)",");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().sort((SortBuilder)SortBuilders.fieldSort((String)request.getResourceIdField()).unmappedType("long")).query(this.buildQuery(tokens, request.getResourceIdField()));
        if (request.getPageParams() != null) {
            sourceBuilder.from(request.getPageParams().getFrom()).size(request.getPageParams().getSize());
        }
        sourceBuilder.trackTotalHits(true);
        IndicesOptions indicesOptions = SearchRequest.DEFAULT_INDICES_OPTIONS;
        SearchRequest searchRequest = new SearchRequest(this.getIndices()).indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)indicesOptions.allowNoIndices(), (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed(), (IndicesOptions)indicesOptions)).source(this.customSearchOptions(sourceBuilder));
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.executionOrigin(), searchRequest, new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                ArrayList docs = new ArrayList();
                HashSet<String> foundResourceIds = new HashSet<String>();
                long totalHitCount = response.getHits().getTotalHits().value;
                for (SearchHit hit : response.getHits().getHits()) {
                    BytesReference docSource = hit.getSourceRef();
                    try (StreamInput stream = docSource.streamInput();
                         XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(AbstractTransportGetResourcesAction.this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);){
                        Object resource = AbstractTransportGetResourcesAction.this.parse(parser);
                        String id = AbstractTransportGetResourcesAction.this.extractIdFromResource(resource);
                        if (foundResourceIds.contains(id)) continue;
                        docs.add(resource);
                        foundResourceIds.add(id);
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                }
                ExpandedIdsMatcher requiredMatches = new ExpandedIdsMatcher(tokens, request.isAllowNoResources());
                requiredMatches.filterMatchedIds(foundResourceIds);
                if (requiredMatches.hasUnmatchedIds()) {
                    listener.onFailure((Exception)AbstractTransportGetResourcesAction.this.notFoundException(requiredMatches.unmatchedIdsString()));
                } else if (requiredMatches.isOnlyExact()) {
                    listener.onResponse(new QueryPage(docs, docs.size(), AbstractTransportGetResourcesAction.this.getResultsField()));
                } else {
                    listener.onResponse(new QueryPage(docs, totalHitCount, AbstractTransportGetResourcesAction.this.getResultsField()));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private QueryBuilder buildQuery(String[] tokens, String resourceIdField) {
        QueryBuilder additionalQuery;
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        if (!Strings.isAllOrWildcard((String[])tokens)) {
            BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
            ArrayList<String> terms = new ArrayList<String>();
            for (String token : tokens) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    shouldQueries.should((QueryBuilder)QueryBuilders.wildcardQuery((String)resourceIdField, (String)token));
                    continue;
                }
                terms.add(token);
            }
            if (!terms.isEmpty()) {
                shouldQueries.should((QueryBuilder)QueryBuilders.termsQuery((String)resourceIdField, terms));
            }
            if (!shouldQueries.should().isEmpty()) {
                boolQuery.filter((QueryBuilder)shouldQueries);
            }
        }
        if ((additionalQuery = this.additionalQuery()) != null) {
            boolQuery.filter(additionalQuery);
        }
        return boolQuery.hasClauses() ? boolQuery : QueryBuilders.matchAllQuery();
    }

    protected SearchSourceBuilder customSearchOptions(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder;
    }

    @Nullable
    protected QueryBuilder additionalQuery() {
        return null;
    }

    protected abstract ParseField getResultsField();

    protected abstract String[] getIndices();

    protected abstract Resource parse(XContentParser var1) throws IOException;

    protected abstract ResourceNotFoundException notFoundException(String var1);

    protected abstract String executionOrigin();

    protected abstract String extractIdFromResource(Resource var1);
}

