/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseStateListener;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.monitoring.MonitoringField;

public class XPackLicenseState {
    private static final Set<Feature> NON_TRACKED_FEATURES = org.elasticsearch.common.collect.Set.of((Object[])new Feature[]{Feature.SECURITY_IP_FILTERING, Feature.SECURITY_ALL_REALMS, Feature.SECURITY_STANDARD_REALMS});
    static final Map<String, String[]> EXPIRATION_MESSAGES;
    static final Map<String, BiFunction<License.OperationMode, License.OperationMode, String[]>> ACKNOWLEDGMENT_MESSAGES;
    private final List<LicenseStateListener> listeners;
    private final boolean isSecurityEnabled;
    private final boolean isSecurityExplicitlyEnabled;
    private final Map<Feature, LongAccumulator> lastUsed;
    private final LongSupplier epochMillisProvider;
    private volatile Status status = new Status(License.OperationMode.TRIAL, true);

    private static String[] securityAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: {
                        return new String[]{"Security will default to disabled (set " + XPackSettings.SECURITY_ENABLED.getKey() + " to enable security)."};
                    }
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Security will default to disabled (set " + XPackSettings.SECURITY_ENABLED.getKey() + " to enable security).", "Authentication will be limited to the native and file realms.", "Security tokens and API keys will not be supported.", "IP filtering and auditing will be disabled.", "Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
                break;
            }
            case GOLD: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: 
                    case BASIC: {
                        return new String[]{"Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
                break;
            }
            case STANDARD: {
                switch (currentMode) {
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: 
                    case BASIC: {
                        return new String[]{"Authentication will be limited to the native realms.", "IP filtering and auditing will be disabled.", "Field and document level access control will be disabled.", "Custom realms will be ignored.", "A custom authorization engine will be ignored."};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] watcherAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Watcher will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] monitoringAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                switch (currentMode) {
                    case STANDARD: 
                    case TRIAL: 
                    case GOLD: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{LoggerMessageFormat.format((String)"Multi-cluster support is disabled for clusters with [{}] license. If you are\nrunning multiple clusters, users won't be able to access the clusters with\n[{}] licenses from within a single X-Pack Kibana instance. You will have to deploy a\nseparate and dedicated X-pack Kibana instance for each [{}] cluster you wish to monitor.", (Object[])new Object[]{newMode, newMode, newMode}), LoggerMessageFormat.format((String)"Automatic index cleanup is locked to {} days for clusters with [{}] license.", (Object[])new Object[]{((TimeValue)MonitoringField.HISTORY_DURATION.getDefault(Settings.EMPTY)).days(), newMode})};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] graphAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Graph will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] machineLearningAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"Machine learning will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] logstashAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                if (XPackLicenseState.isBasic(currentMode)) break;
                return new String[]{"Logstash will no longer poll for centrally-managed pipelines"};
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] beatsAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case BASIC: {
                if (XPackLicenseState.isBasic(currentMode)) break;
                return new String[]{"Beats will no longer be able to use centrally-managed configuration"};
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] sqlAcknowledgementMessages(License.OperationMode currentMode, License.OperationMode newMode) {
        switch (newMode) {
            case STANDARD: 
            case GOLD: 
            case BASIC: {
                switch (currentMode) {
                    case TRIAL: 
                    case PLATINUM: 
                    case ENTERPRISE: {
                        return new String[]{"JDBC and ODBC support will be disabled, but you can continue to use SQL CLI and REST endpoint"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static String[] ccrAcknowledgementMessages(License.OperationMode current, License.OperationMode next) {
        switch (current) {
            case TRIAL: 
            case PLATINUM: 
            case ENTERPRISE: {
                switch (next) {
                    case STANDARD: 
                    case GOLD: 
                    case BASIC: 
                    case MISSING: {
                        return new String[]{"Cross-Cluster Replication will be disabled"};
                    }
                }
            }
        }
        return Strings.EMPTY_ARRAY;
    }

    private static boolean isBasic(License.OperationMode mode) {
        return mode == License.OperationMode.BASIC;
    }

    public XPackLicenseState(Settings settings, LongSupplier epochMillisProvider) {
        this.listeners = new CopyOnWriteArrayList<LicenseStateListener>();
        this.isSecurityEnabled = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
        this.isSecurityExplicitlyEnabled = this.isSecurityEnabled && XPackLicenseState.isSecurityExplicitlyEnabled(settings);
        EnumMap<Feature, LongAccumulator> lastUsed = new EnumMap<Feature, LongAccumulator>(Feature.class);
        for (Feature feature : Feature.values()) {
            if (feature.minimumOperationMode.compareTo(License.OperationMode.BASIC) <= 0 || NON_TRACKED_FEATURES.contains((Object)feature)) continue;
            lastUsed.put(feature, new LongAccumulator(Long::max, 0L));
        }
        this.lastUsed = lastUsed;
        this.epochMillisProvider = epochMillisProvider;
    }

    private XPackLicenseState(List<LicenseStateListener> listeners, boolean isSecurityEnabled, boolean isSecurityExplicitlyEnabled, Status status, Map<Feature, LongAccumulator> lastUsed, LongSupplier epochMillisProvider) {
        this.listeners = listeners;
        this.isSecurityEnabled = isSecurityEnabled;
        this.isSecurityExplicitlyEnabled = isSecurityExplicitlyEnabled;
        this.status = status;
        this.lastUsed = lastUsed;
        this.epochMillisProvider = epochMillisProvider;
    }

    private static boolean isSecurityExplicitlyEnabled(Settings settings) {
        return settings.hasValue(XPackSettings.SECURITY_ENABLED.getKey());
    }

    private <T> T executeAgainstStatus(Function<Status, T> statusFn) {
        return statusFn.apply(this.status);
    }

    private boolean checkAgainstStatus(Predicate<Status> statusPredicate) {
        return statusPredicate.test(this.status);
    }

    void update(License.OperationMode mode, boolean active, @Nullable Version mostRecentTrialVersion) {
        this.status = new Status(mode, active);
        this.listeners.forEach(LicenseStateListener::licenseStateChanged);
    }

    public void addListener(LicenseStateListener listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    public void removeListener(LicenseStateListener listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }

    public License.OperationMode getOperationMode() {
        return this.executeAgainstStatus(status -> status.mode);
    }

    public boolean allowForAllLicenses() {
        return this.checkAgainstStatus(status -> status.active);
    }

    boolean isActive() {
        return this.checkAgainstStatus(status -> status.active);
    }

    public boolean checkFeature(Feature feature) {
        boolean allowed = this.isAllowed(feature);
        LongAccumulator maxEpochAccumulator = this.lastUsed.get((Object)feature);
        if (maxEpochAccumulator != null) {
            maxEpochAccumulator.accumulate(this.epochMillisProvider.getAsLong());
        }
        return allowed;
    }

    public boolean isAllowed(Feature feature) {
        return this.isAllowedByLicense(feature.minimumOperationMode, feature.needsActive);
    }

    public Map<Feature, Long> getLastUsed() {
        return this.lastUsed.entrySet().stream().filter(e -> ((LongAccumulator)e.getValue()).get() != 0L).collect(Collectors.toMap(Map.Entry::getKey, e -> ((LongAccumulator)e.getValue()).get()));
    }

    public static boolean isMachineLearningAllowedForOperationMode(License.OperationMode operationMode) {
        return XPackLicenseState.isAllowedByOperationMode(operationMode, License.OperationMode.PLATINUM);
    }

    public static boolean isTransformAllowedForOperationMode(License.OperationMode operationMode) {
        return operationMode != License.OperationMode.MISSING;
    }

    public static boolean isFipsAllowedForOperationMode(License.OperationMode operationMode) {
        return XPackLicenseState.isAllowedByOperationMode(operationMode, License.OperationMode.PLATINUM);
    }

    public boolean isSecurityEnabled() {
        return XPackLicenseState.isSecurityEnabled(this.status.mode, this.isSecurityExplicitlyEnabled, this.isSecurityEnabled);
    }

    public static boolean isTransportTlsRequired(License license, Settings settings) {
        if (license == null) {
            return false;
        }
        switch (license.operationMode()) {
            case STANDARD: 
            case GOLD: 
            case PLATINUM: 
            case ENTERPRISE: {
                return (Boolean)XPackSettings.SECURITY_ENABLED.get(settings);
            }
            case BASIC: {
                return (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false && XPackLicenseState.isSecurityExplicitlyEnabled(settings);
            }
            case TRIAL: 
            case MISSING: {
                return false;
            }
        }
        throw new AssertionError((Object)("unknown operation mode [" + (Object)((Object)license.operationMode()) + "]"));
    }

    private static boolean isSecurityEnabled(License.OperationMode mode, boolean isSecurityExplicitlyEnabled, boolean isSecurityEnabled) {
        switch (mode) {
            case TRIAL: 
            case BASIC: {
                return isSecurityExplicitlyEnabled;
            }
        }
        return isSecurityEnabled;
    }

    public static boolean isCcrAllowedForOperationMode(License.OperationMode operationMode) {
        return XPackLicenseState.isAllowedByOperationMode(operationMode, License.OperationMode.PLATINUM);
    }

    public static boolean isAllowedByOperationMode(License.OperationMode operationMode, License.OperationMode minimumMode) {
        if (License.OperationMode.TRIAL == operationMode) {
            return true;
        }
        return operationMode.compareTo(minimumMode) >= 0;
    }

    public XPackLicenseState copyCurrentLicenseState() {
        return this.executeAgainstStatus(status -> new XPackLicenseState(this.listeners, this.isSecurityEnabled, this.isSecurityExplicitlyEnabled, (Status)status, this.lastUsed, this.epochMillisProvider));
    }

    public boolean isAllowedByLicense(License.OperationMode minimumMode, boolean needActive) {
        return this.checkAgainstStatus(status -> {
            if (needActive && !status.active) {
                return false;
            }
            return XPackLicenseState.isAllowedByOperationMode(status.mode, minimumMode);
        });
    }

    public boolean isAllowedByLicense(License.OperationMode minimumMode) {
        return this.isAllowedByLicense(minimumMode, true);
    }

    static {
        LinkedHashMap<String, Object> messages = new LinkedHashMap<String, Object>();
        messages.put("security", new String[]{"Cluster health, cluster stats and indices stats operations are blocked", "All data operations (read and write) continue to work"});
        messages.put("watcher", new String[]{"PUT / GET watch APIs are disabled, DELETE watch API continues to work", "Watches execute and write to the history", "The actions of the watches don't execute"});
        messages.put("monitoring", new String[]{"The agent will stop collecting cluster and indices metrics", "The agent will stop automatically cleaning indices older than [xpack.monitoring.history.duration]"});
        messages.put("graph", new String[]{"Graph explore APIs are disabled"});
        messages.put("ml", new String[]{"Machine learning APIs are disabled"});
        messages.put("logstash", new String[]{"Logstash will continue to poll centrally-managed pipelines"});
        messages.put("beats", new String[]{"Beats will continue to poll centrally-managed configuration"});
        messages.put("deprecation", new String[]{"Deprecation APIs are disabled"});
        messages.put("upgrade", new String[]{"Upgrade API is disabled"});
        messages.put("sql", new String[]{"SQL support is disabled"});
        messages.put("rollup", new String[]{"Creating and Starting rollup jobs will no longer be allowed.", "Stopping/Deleting existing jobs, RollupCaps API and RollupSearch continue to function."});
        messages.put("transform", new String[]{"Creating, starting, updating transforms will no longer be allowed.", "Stopping/Deleting existing transforms continue to function."});
        messages.put("analytics", new String[]{"Aggregations provided by Analytics plugin are no longer usable."});
        messages.put("ccr", new String[]{"Creating new follower indices will be blocked", "Configuring auto-follow patterns will be blocked", "Auto-follow patterns will no longer discover new leader indices", "The CCR monitoring endpoint will be blocked", "Existing follower indices will continue to replicate data"});
        EXPIRATION_MESSAGES = Collections.unmodifiableMap(messages);
        messages = new LinkedHashMap();
        messages.put("security", XPackLicenseState::securityAcknowledgementMessages);
        messages.put("watcher", XPackLicenseState::watcherAcknowledgementMessages);
        messages.put("monitoring", XPackLicenseState::monitoringAcknowledgementMessages);
        messages.put("graph", XPackLicenseState::graphAcknowledgementMessages);
        messages.put("ml", XPackLicenseState::machineLearningAcknowledgementMessages);
        messages.put("logstash", XPackLicenseState::logstashAcknowledgementMessages);
        messages.put("beats", XPackLicenseState::beatsAcknowledgementMessages);
        messages.put("sql", XPackLicenseState::sqlAcknowledgementMessages);
        messages.put("ccr", XPackLicenseState::ccrAcknowledgementMessages);
        ACKNOWLEDGMENT_MESSAGES = Collections.unmodifiableMap(messages);
    }

    private static class Status {
        final License.OperationMode mode;
        final boolean active;

        Status(License.OperationMode mode, boolean active) {
            this.mode = mode;
            this.active = active;
        }
    }

    public static enum Feature {
        SECURITY(License.OperationMode.BASIC, false),
        SECURITY_IP_FILTERING(License.OperationMode.GOLD, false),
        SECURITY_AUDITING(License.OperationMode.GOLD, false),
        SECURITY_DLS_FLS(License.OperationMode.PLATINUM, false),
        SECURITY_ALL_REALMS(License.OperationMode.PLATINUM, false),
        SECURITY_STANDARD_REALMS(License.OperationMode.GOLD, false),
        SECURITY_CUSTOM_ROLE_PROVIDERS(License.OperationMode.PLATINUM, true),
        SECURITY_TOKEN_SERVICE(License.OperationMode.GOLD, false),
        SECURITY_API_KEY_SERVICE(License.OperationMode.MISSING, false),
        SECURITY_AUTHORIZATION_REALM(License.OperationMode.PLATINUM, true),
        SECURITY_AUTHORIZATION_ENGINE(License.OperationMode.PLATINUM, true),
        SECURITY_STATS_AND_HEALTH(License.OperationMode.MISSING, true),
        WATCHER(License.OperationMode.STANDARD, true),
        MONITORING(License.OperationMode.MISSING, true),
        MONITORING_CLUSTER_ALERTS(License.OperationMode.STANDARD, true),
        MONITORING_UPDATE_RETENTION(License.OperationMode.STANDARD, false),
        CCR(License.OperationMode.PLATINUM, true),
        GRAPH(License.OperationMode.PLATINUM, true),
        MACHINE_LEARNING(License.OperationMode.PLATINUM, true),
        TRANSFORM(License.OperationMode.MISSING, true),
        ROLLUP(License.OperationMode.MISSING, true),
        VOTING_ONLY(License.OperationMode.MISSING, true),
        LOGSTASH(License.OperationMode.STANDARD, true),
        DEPRECATION(License.OperationMode.MISSING, true),
        ILM(License.OperationMode.MISSING, true),
        ENRICH(License.OperationMode.MISSING, true),
        EQL(License.OperationMode.MISSING, true),
        SQL(License.OperationMode.MISSING, true),
        JDBC(License.OperationMode.PLATINUM, true),
        ODBC(License.OperationMode.PLATINUM, true),
        FLATTENED(License.OperationMode.MISSING, true),
        VECTORS(License.OperationMode.MISSING, true),
        SPATIAL(License.OperationMode.MISSING, true),
        SPATIAL_GEO_CENTROID(License.OperationMode.GOLD, true),
        SPATIAL_GEO_GRID(License.OperationMode.GOLD, true),
        ANALYTICS(License.OperationMode.MISSING, true),
        SEARCHABLE_SNAPSHOTS(License.OperationMode.ENTERPRISE, true);

        final License.OperationMode minimumOperationMode;
        final boolean needsActive;

        private Feature(License.OperationMode minimumOperationMode, boolean needsActive) {
            this.minimumOperationMode = minimumOperationMode;
            this.needsActive = needsActive;
        }
    }
}

