/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.protocol.xpack.license.GetLicenseRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestGetLicenseAction
extends XPackRestHandler {
    RestGetLicenseAction() {
    }

    public List<RestHandler.Route> routes() {
        return Collections.emptyList();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return Collections.singletonList(new RestHandler.ReplacedRoute(RestRequest.Method.GET, "/_license", RestRequest.Method.GET, URI_BASE + "/license"));
    }

    public String getName() {
        return "get_license";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        boolean hideEnterprise = !request.paramAsBoolean("accept_enterprise", false);
        int licenseVersion = hideEnterprise ? 4 : 5;
        HashMap<String, String> overrideParams = new HashMap<String, String>(3);
        overrideParams.put("rest_view", "true");
        overrideParams.put("license_version", String.valueOf(licenseVersion));
        overrideParams.put("hide_enterprise", String.valueOf(hideEnterprise));
        ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(overrideParams, (ToXContent.Params)request);
        GetLicenseRequest getLicenseRequest = new GetLicenseRequest();
        getLicenseRequest.local(request.paramAsBoolean("local", getLicenseRequest.local()));
        return arg_0 -> this.lambda$doPrepareRequest$0(client, getLicenseRequest, request, (ToXContent.Params)params, arg_0);
    }

    private /* synthetic */ void lambda$doPrepareRequest$0(XPackClient client, GetLicenseRequest getLicenseRequest, final RestRequest request, final ToXContent.Params params, RestChannel channel) throws Exception {
        client.es().admin().cluster().execute((ActionType)GetLicenseAction.INSTANCE, (ActionRequest)getLicenseRequest, (ActionListener)new RestBuilderListener<GetLicenseResponse>(channel){

            public RestResponse buildResponse(GetLicenseResponse response, XContentBuilder builder) throws Exception {
                if (!request.hasParam("pretty")) {
                    builder.prettyPrint().lfAtEnd();
                }
                boolean hasLicense = response.license() != null;
                builder.startObject();
                if (hasLicense) {
                    builder.startObject("license");
                    response.license().toInnerXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(hasLicense ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

