/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class RangeAggregator
extends BucketsAggregator {
    public static final ParseField RANGES_FIELD = new ParseField("ranges", new String[0]);
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final Range[] ranges;
    final boolean keyed;
    final InternalRange.Factory rangeFactory;
    final double[] maxTo;

    public RangeAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, InternalRange.Factory rangeFactory, Range[] ranges, boolean keyed, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality.multiply(ranges.length), metadata);
        assert (valuesSource != null);
        this.valuesSource = valuesSource;
        this.format = format;
        this.keyed = keyed;
        this.rangeFactory = rangeFactory;
        this.ranges = ranges;
        this.maxTo = new double[this.ranges.length];
        this.maxTo[0] = this.ranges[0].to;
        for (int i = 1; i < this.ranges.length; ++i) {
            this.maxTo[i] = Math.max(this.ranges[i].to, this.maxTo[i - 1]);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    int lo = 0;
                    for (int i = 0; i < valuesCount; ++i) {
                        double value = values.nextValue();
                        lo = this.collect(doc, value, bucket, lo);
                    }
                }
            }

            private int collect(int doc, double value, long owningBucketOrdinal, int lowBound) throws IOException {
                int lo = lowBound;
                int hi = RangeAggregator.this.ranges.length - 1;
                int mid = lo + hi >>> 1;
                while (lo <= hi) {
                    if (value < RangeAggregator.this.ranges[mid].from) {
                        hi = mid - 1;
                    } else {
                        if (!(value >= RangeAggregator.this.maxTo[mid])) break;
                        lo = mid + 1;
                    }
                    mid = lo + hi >>> 1;
                }
                if (lo > hi) {
                    return lo;
                }
                int startLo = lo;
                int startHi = mid;
                while (startLo <= startHi) {
                    int startMid = startLo + startHi >>> 1;
                    if (value >= RangeAggregator.this.maxTo[startMid]) {
                        startLo = startMid + 1;
                        continue;
                    }
                    startHi = startMid - 1;
                }
                int endLo = mid;
                int endHi = hi;
                while (endLo <= endHi) {
                    int endMid = endLo + endHi >>> 1;
                    if (value < RangeAggregator.this.ranges[endMid].from) {
                        endHi = endMid - 1;
                        continue;
                    }
                    endLo = endMid + 1;
                }
                assert (startLo == lowBound || value >= RangeAggregator.this.maxTo[startLo - 1]);
                assert (endHi == RangeAggregator.this.ranges.length - 1 || value < RangeAggregator.this.ranges[endHi + 1].from);
                for (int i = startLo; i <= endHi; ++i) {
                    if (!RangeAggregator.this.ranges[i].matches(value)) continue;
                    RangeAggregator.this.collectBucket(sub, doc, RangeAggregator.this.subBucketOrdinal(owningBucketOrdinal, i));
                }
                return endHi + 1;
            }
        };
    }

    private long subBucketOrdinal(long owningBucketOrdinal, int rangeOrd) {
        return owningBucketOrdinal * (long)this.ranges.length + (long)rangeOrd;
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForFixedBucketCount(owningBucketOrds, this.ranges.length, (offsetInOwningOrd, docCount, subAggregationResults) -> {
            Range range = this.ranges[offsetInOwningOrd];
            return this.rangeFactory.createBucket(range.key, range.from, range.to, docCount, subAggregationResults, this.keyed, this.format);
        }, buckets -> this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalAggregations subAggs = this.buildEmptySubAggregations();
        ArrayList buckets = new ArrayList(this.ranges.length);
        for (int i = 0; i < this.ranges.length; ++i) {
            Range range = this.ranges[i];
            Object bucket = this.rangeFactory.createBucket(range.key, range.from, range.to, 0L, subAggs, this.keyed, this.format);
            buckets.add(bucket);
        }
        return this.rangeFactory.create(this.name, buckets, this.format, this.keyed, this.metadata());
    }

    public static class Range
    implements Writeable,
    ToXContentObject {
        public static final ParseField KEY_FIELD = new ParseField("key", new String[0]);
        public static final ParseField FROM_FIELD = new ParseField("from", new String[0]);
        public static final ParseField TO_FIELD = new ParseField("to", new String[0]);
        protected final String key;
        protected final double from;
        protected final String fromAsStr;
        protected final double to;
        protected final String toAsStr;
        public static final ConstructingObjectParser<Range, Void> PARSER = new ConstructingObjectParser("range", arg -> {
            String key = (String)arg[0];
            Object from = arg[1];
            Object to = arg[2];
            Double fromDouble = from instanceof Number ? Double.valueOf(((Number)from).doubleValue()) : null;
            Double toDouble = to instanceof Number ? Double.valueOf(((Number)to).doubleValue()) : null;
            String fromStr = from instanceof String ? (String)from : null;
            String toStr = to instanceof String ? (String)to : null;
            return new Range(key, fromDouble, fromStr, toDouble, toStr);
        });

        public Range(String key, Double from, String fromAsStr, Double to, String toAsStr) {
            this.key = key;
            this.from = from == null ? Double.NEGATIVE_INFINITY : from;
            this.fromAsStr = fromAsStr;
            this.to = to == null ? Double.POSITIVE_INFINITY : to;
            this.toAsStr = toAsStr;
        }

        public Range(String key, Double from, Double to) {
            this(key, from, null, to, null);
        }

        public Range(String key, String from, String to) {
            this(key, null, from, null, to);
        }

        public Range(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.fromAsStr = in.readOptionalString();
            this.toAsStr = in.readOptionalString();
            this.from = in.readDouble();
            this.to = in.readDouble();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeOptionalString(this.fromAsStr);
            out.writeOptionalString(this.toAsStr);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
        }

        public double getFrom() {
            return this.from;
        }

        public double getTo() {
            return this.to;
        }

        public String getFromAsString() {
            return this.fromAsStr;
        }

        public String getToAsString() {
            return this.toAsStr;
        }

        public String getKey() {
            return this.key;
        }

        boolean matches(double value) {
            return value >= this.from && value < this.to;
        }

        public String toString() {
            return "[" + this.from + " to " + this.to + ")";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.key != null) {
                builder.field(KEY_FIELD.getPreferredName(), this.key);
            }
            if (Double.isFinite(this.from)) {
                builder.field(FROM_FIELD.getPreferredName(), this.from);
            }
            if (Double.isFinite(this.to)) {
                builder.field(TO_FIELD.getPreferredName(), this.to);
            }
            if (this.fromAsStr != null) {
                builder.field(FROM_FIELD.getPreferredName(), this.fromAsStr);
            }
            if (this.toAsStr != null) {
                builder.field(TO_FIELD.getPreferredName(), this.toAsStr);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.from, this.fromAsStr, this.to, this.toAsStr);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.from, other.from) && Objects.equals(this.fromAsStr, other.fromAsStr) && Objects.equals(this.to, other.to) && Objects.equals(this.toAsStr, other.toAsStr);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), KEY_FIELD, ObjectParser.ValueType.DOUBLE);
            ContextParser<Void, Object> fromToParser = (p, c) -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return p.text();
                }
                if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                    return p.doubleValue();
                }
                return null;
            };
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), fromToParser, FROM_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), fromToParser, TO_FIELD, ObjectParser.ValueType.DOUBLE_OR_NULL);
        }
    }

    public static class Unmapped<R extends Range>
    extends NonCollectingAggregator {
        private final R[] ranges;
        private final boolean keyed;
        private final InternalRange.Factory factory;
        private final DocValueFormat format;

        public Unmapped(String name, AggregatorFactories factories, R[] ranges, boolean keyed, DocValueFormat format, SearchContext context, Aggregator parent, InternalRange.Factory factory, Map<String, Object> metadata) throws IOException {
            super(name, context, parent, factories, metadata);
            this.ranges = ranges;
            this.keyed = keyed;
            this.format = format;
            this.factory = factory;
        }

        @Override
        public InternalAggregation buildEmptyAggregation() {
            InternalAggregations subAggs = this.buildEmptySubAggregations();
            ArrayList buckets = new ArrayList(this.ranges.length);
            for (R range : this.ranges) {
                buckets.add(this.factory.createBucket(((Range)range).key, ((Range)range).from, ((Range)range).to, 0L, subAggs, this.keyed, this.format));
            }
            return this.factory.create(this.name, buckets, this.format, this.keyed, this.metadata());
        }
    }
}

