/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.DoubleBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.NumericHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.RangeHistogramAggregator;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public final class HistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final double interval;
    private final double offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final DoubleBounds extendedBounds;
    private final DoubleBounds hardBounds;

    static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(HistogramAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.RANGE, RangeHistogramAggregator::new, true);
        builder.register(HistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN), NumericHistogramAggregator::new, true);
    }

    public HistogramAggregatorFactory(String name, ValuesSourceConfig config, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, DoubleBounds extendedBounds, DoubleBounds hardBounds, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.extendedBounds = extendedBounds;
        this.hardBounds = hardBounds;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(HistogramAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, cardinality, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new NumericHistogramAggregator(this.name, this.factories, this.interval, this.offset, this.order, this.keyed, this.minDocCount, this.extendedBounds, this.hardBounds, this.config, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }
}

