/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.rest.RestRequest;

public class IndicesOptions
implements ToXContentFragment {
    public static final IndicesOptions STRICT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.HIDDEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.HIDDEN));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions LENIENT_EXPAND_OPEN_CLOSED_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.IGNORE_UNAVAILABLE), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED, WildcardStates.HIDDEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED));
    public static final IndicesOptions STRICT_EXPAND_OPEN_CLOSED_HIDDEN = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.CLOSED, WildcardStates.HIDDEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_HIDDEN_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.of(WildcardStates.OPEN, WildcardStates.HIDDEN));
    public static final IndicesOptions STRICT_EXPAND_OPEN_FORBID_CLOSED_IGNORE_THROTTLED = new IndicesOptions(EnumSet.of(Option.ALLOW_NO_INDICES, Option.FORBID_CLOSED_INDICES, Option.IGNORE_THROTTLED), EnumSet.of(WildcardStates.OPEN));
    public static final IndicesOptions STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED = new IndicesOptions(EnumSet.of(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES, Option.FORBID_CLOSED_INDICES), EnumSet.noneOf(WildcardStates.class));
    private final EnumSet<Option> options;
    private final EnumSet<WildcardStates> expandWildcards;

    public IndicesOptions(EnumSet<Option> options, EnumSet<WildcardStates> expandWildcards) {
        this.options = options;
        this.expandWildcards = expandWildcards;
    }

    private IndicesOptions(Collection<Option> options, Collection<WildcardStates> expandWildcards) {
        this(options.isEmpty() ? Option.NONE : EnumSet.copyOf(options), expandWildcards.isEmpty() ? WildcardStates.NONE : EnumSet.copyOf(expandWildcards));
    }

    public boolean ignoreUnavailable() {
        return this.options.contains((Object)Option.IGNORE_UNAVAILABLE);
    }

    public boolean allowNoIndices() {
        return this.options.contains((Object)Option.ALLOW_NO_INDICES);
    }

    public boolean expandWildcardsOpen() {
        return this.expandWildcards.contains((Object)WildcardStates.OPEN);
    }

    public boolean expandWildcardsClosed() {
        return this.expandWildcards.contains((Object)WildcardStates.CLOSED);
    }

    public boolean expandWildcardsHidden() {
        return this.expandWildcards.contains((Object)WildcardStates.HIDDEN);
    }

    public boolean forbidClosedIndices() {
        return this.options.contains((Object)Option.FORBID_CLOSED_INDICES);
    }

    public boolean allowAliasesToMultipleIndices() {
        return !this.options.contains((Object)Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
    }

    public boolean ignoreAliases() {
        return this.options.contains((Object)Option.IGNORE_ALIASES);
    }

    public boolean ignoreThrottled() {
        return this.options.contains((Object)Option.IGNORE_THROTTLED);
    }

    public EnumSet<WildcardStates> getExpandWildcards() {
        return EnumSet.copyOf(this.expandWildcards);
    }

    public void writeIndicesOptions(StreamOutput out) throws IOException {
        EnumSet<Option> options = this.options;
        if (out.getVersion().before(Version.V_6_6_0) && options.contains((Object)Option.IGNORE_THROTTLED)) {
            options = EnumSet.copyOf(options);
            options.remove((Object)Option.IGNORE_THROTTLED);
        }
        out.writeEnumSet(options);
        if (out.getVersion().before(Version.V_7_7_0) && this.expandWildcards.contains((Object)WildcardStates.HIDDEN)) {
            EnumSet<WildcardStates> states = EnumSet.copyOf(this.expandWildcards);
            states.remove((Object)WildcardStates.HIDDEN);
            out.writeEnumSet(states);
        } else {
            out.writeEnumSet(this.expandWildcards);
        }
    }

    public static IndicesOptions readIndicesOptions(StreamInput in) throws IOException {
        EnumSet<Option> options = in.readEnumSet(Option.class);
        EnumSet<WildcardStates> states = in.readEnumSet(WildcardStates.class);
        if (in.getVersion().before(Version.V_7_7_0)) {
            states.add(WildcardStates.HIDDEN);
        }
        return new IndicesOptions(options, states);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean expandToHiddenIndices) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, expandToHiddenIndices, true, false, false, false);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, IndicesOptions defaultOptions) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, defaultOptions.expandWildcardsHidden(), defaultOptions.allowAliasesToMultipleIndices(), defaultOptions.forbidClosedIndices(), defaultOptions.ignoreAliases(), defaultOptions.ignoreThrottled());
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases, boolean ignoreThrottled) {
        return IndicesOptions.fromOptions(ignoreUnavailable, allowNoIndices, expandToOpenIndices, expandToClosedIndices, false, allowAliasesToMultipleIndices, forbidClosedIndices, ignoreAliases, ignoreThrottled);
    }

    public static IndicesOptions fromOptions(boolean ignoreUnavailable, boolean allowNoIndices, boolean expandToOpenIndices, boolean expandToClosedIndices, boolean expandToHiddenIndices, boolean allowAliasesToMultipleIndices, boolean forbidClosedIndices, boolean ignoreAliases, boolean ignoreThrottled) {
        EnumSet<Option> opts = EnumSet.noneOf(Option.class);
        EnumSet<WildcardStates> wildcards = EnumSet.noneOf(WildcardStates.class);
        if (ignoreUnavailable) {
            opts.add(Option.IGNORE_UNAVAILABLE);
        }
        if (allowNoIndices) {
            opts.add(Option.ALLOW_NO_INDICES);
        }
        if (expandToOpenIndices) {
            wildcards.add(WildcardStates.OPEN);
        }
        if (expandToClosedIndices) {
            wildcards.add(WildcardStates.CLOSED);
        }
        if (expandToHiddenIndices) {
            wildcards.add(WildcardStates.HIDDEN);
        }
        if (!allowAliasesToMultipleIndices) {
            opts.add(Option.FORBID_ALIASES_TO_MULTIPLE_INDICES);
        }
        if (forbidClosedIndices) {
            opts.add(Option.FORBID_CLOSED_INDICES);
        }
        if (ignoreAliases) {
            opts.add(Option.IGNORE_ALIASES);
        }
        if (ignoreThrottled) {
            opts.add(Option.IGNORE_THROTTLED);
        }
        return new IndicesOptions(opts, wildcards);
    }

    public static IndicesOptions fromRequest(RestRequest request, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(request.param("expand_wildcards"), request.param("ignore_unavailable"), request.param("allow_no_indices"), request.param("ignore_throttled"), defaultSettings);
    }

    public static IndicesOptions fromMap(Map<String, Object> map, IndicesOptions defaultSettings) {
        return IndicesOptions.fromParameters(map.containsKey("expand_wildcards") ? map.get("expand_wildcards") : map.get("expandWildcards"), map.containsKey("ignore_unavailable") ? map.get("ignore_unavailable") : map.get("ignoreUnavailable"), map.containsKey("allow_no_indices") ? map.get("allow_no_indices") : map.get("allowNoIndices"), map.containsKey("ignore_throttled") ? map.get("ignore_throttled") : map.get("ignoreThrottled"), defaultSettings);
    }

    public static boolean isIndicesOptions(String name) {
        return "expand_wildcards".equals(name) || "expandWildcards".equals(name) || "ignore_unavailable".equals(name) || "ignoreUnavailable".equals(name) || "ignore_throttled".equals(name) || "ignoreThrottled".equals(name) || "allow_no_indices".equals(name) || "allowNoIndices".equals(name);
    }

    public static IndicesOptions fromParameters(Object wildcardsString, Object ignoreUnavailableString, Object allowNoIndicesString, Object ignoreThrottled, IndicesOptions defaultSettings) {
        if (wildcardsString == null && ignoreUnavailableString == null && allowNoIndicesString == null && ignoreThrottled == null) {
            return defaultSettings;
        }
        EnumSet<WildcardStates> wildcards = WildcardStates.parseParameter(wildcardsString, defaultSettings.expandWildcards);
        return IndicesOptions.fromOptions(XContentMapValues.nodeBooleanValue(ignoreUnavailableString, "ignore_unavailable", defaultSettings.ignoreUnavailable()), XContentMapValues.nodeBooleanValue(allowNoIndicesString, "allow_no_indices", defaultSettings.allowNoIndices()), wildcards.contains((Object)WildcardStates.OPEN), wildcards.contains((Object)WildcardStates.CLOSED), wildcards.contains((Object)WildcardStates.HIDDEN), defaultSettings.allowAliasesToMultipleIndices(), defaultSettings.forbidClosedIndices(), defaultSettings.ignoreAliases(), XContentMapValues.nodeBooleanValue(ignoreThrottled, "ignore_throttled", defaultSettings.ignoreThrottled()));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("expand_wildcards");
        for (WildcardStates expandWildcard : this.expandWildcards) {
            builder.value(expandWildcard.toString().toLowerCase(Locale.ROOT));
        }
        builder.endArray();
        builder.field("ignore_unavailable", this.ignoreUnavailable());
        builder.field("allow_no_indices", this.allowNoIndices());
        builder.field("ignore_throttled", this.ignoreThrottled());
        return builder;
    }

    public static IndicesOptions strictExpandOpen() {
        return STRICT_EXPAND_OPEN;
    }

    public static IndicesOptions strictExpandOpenHidden() {
        return STRICT_EXPAND_OPEN_HIDDEN;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosed() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED;
    }

    public static IndicesOptions strictExpandOpenAndForbidClosedIgnoreThrottled() {
        return STRICT_EXPAND_OPEN_FORBID_CLOSED_IGNORE_THROTTLED;
    }

    public static IndicesOptions strictExpand() {
        return STRICT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions strictExpandHidden() {
        return STRICT_EXPAND_OPEN_CLOSED_HIDDEN;
    }

    public static IndicesOptions strictSingleIndexNoExpandForbidClosed() {
        return STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
    }

    public static IndicesOptions lenientExpandOpen() {
        return LENIENT_EXPAND_OPEN;
    }

    public static IndicesOptions lenientExpandOpenHidden() {
        return LENIENT_EXPAND_OPEN_HIDDEN;
    }

    public static IndicesOptions lenientExpand() {
        return LENIENT_EXPAND_OPEN_CLOSED;
    }

    public static IndicesOptions lenientExpandHidden() {
        return LENIENT_EXPAND_OPEN_CLOSED_HIDDEN;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndicesOptions other = (IndicesOptions)obj;
        return this.options.equals(other.options) && this.expandWildcards.equals(other.expandWildcards);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        return 31 * result + this.expandWildcards.hashCode();
    }

    public String toString() {
        return "IndicesOptions[ignore_unavailable=" + this.ignoreUnavailable() + ", allow_no_indices=" + this.allowNoIndices() + ", expand_wildcards_open=" + this.expandWildcardsOpen() + ", expand_wildcards_closed=" + this.expandWildcardsClosed() + ", expand_wildcards_hidden=" + this.expandWildcardsHidden() + ", allow_aliases_to_multiple_indices=" + this.allowAliasesToMultipleIndices() + ", forbid_closed_indices=" + this.forbidClosedIndices() + ", ignore_aliases=" + this.ignoreAliases() + ", ignore_throttled=" + this.ignoreThrottled() + ']';
    }

    public static enum Option {
        IGNORE_UNAVAILABLE,
        IGNORE_ALIASES,
        ALLOW_NO_INDICES,
        FORBID_ALIASES_TO_MULTIPLE_INDICES,
        FORBID_CLOSED_INDICES,
        IGNORE_THROTTLED;

        public static final EnumSet<Option> NONE;

        static {
            NONE = EnumSet.noneOf(Option.class);
        }
    }

    public static enum WildcardStates {
        OPEN,
        CLOSED,
        HIDDEN;

        public static final EnumSet<WildcardStates> NONE;

        public static EnumSet<WildcardStates> parseParameter(Object value, EnumSet<WildcardStates> defaultStates) {
            String[] wildcards;
            if (value == null) {
                return defaultStates;
            }
            EnumSet<WildcardStates> states = EnumSet.noneOf(WildcardStates.class);
            String[] stringArray = wildcards = XContentMapValues.nodeStringArrayValue(value);
            int n = stringArray.length;
            block14: for (int i = 0; i < n; ++i) {
                String wildcard;
                switch (wildcard = stringArray[i]) {
                    case "open": {
                        states.add(OPEN);
                        continue block14;
                    }
                    case "closed": {
                        states.add(CLOSED);
                        continue block14;
                    }
                    case "hidden": {
                        states.add(HIDDEN);
                        continue block14;
                    }
                    case "none": {
                        states.clear();
                        continue block14;
                    }
                    case "all": {
                        states = EnumSet.allOf(WildcardStates.class);
                        continue block14;
                    }
                    default: {
                        throw new IllegalArgumentException("No valid expand wildcard value [" + wildcard + "]");
                    }
                }
            }
            return states;
        }

        public static XContentBuilder toXContent(EnumSet<WildcardStates> states, XContentBuilder builder) throws IOException {
            if (states.isEmpty()) {
                builder.field("expand_wildcards", "none");
            } else if (states.containsAll(EnumSet.allOf(WildcardStates.class))) {
                builder.field("expand_wildcards", "all");
            } else {
                builder.field("expand_wildcards", states.stream().map(state -> state.toString().toLowerCase(Locale.ROOT)).collect(Collectors.joining(",")));
            }
            return builder;
        }

        static {
            NONE = EnumSet.noneOf(WildcardStates.class);
        }
    }
}

