/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class IndicesAliasesRequest
extends AcknowledgedRequest<IndicesAliasesRequest>
implements ToXContentObject {
    private List<AliasActions> allAliasActions = new ArrayList<AliasActions>();
    private String origin = "";
    private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions(false, false, true, false, true, false, true, false);
    public static final ObjectParser<IndicesAliasesRequest, Void> PARSER = new ObjectParser("aliases", IndicesAliasesRequest::new);

    public IndicesAliasesRequest(StreamInput in) throws IOException {
        super(in);
        this.allAliasActions = in.readList(AliasActions::new);
        this.origin = in.getVersion().onOrAfter(Version.V_7_3_0) ? in.readOptionalString() : null;
    }

    public IndicesAliasesRequest() {
    }

    public String origin() {
        return this.origin;
    }

    public IndicesAliasesRequest origin(String origin) {
        this.origin = Objects.requireNonNull(origin);
        return this;
    }

    public IndicesAliasesRequest addAliasAction(AliasActions aliasAction) {
        aliasAction.validate();
        this.allAliasActions.add(aliasAction);
        return this;
    }

    List<AliasActions> aliasActions() {
        return this.allAliasActions;
    }

    public List<AliasActions> getAliasActions() {
        return this.aliasActions();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.allAliasActions.isEmpty()) {
            return ValidateActions.addValidationError("Must specify at least one alias action", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.allAliasActions);
        if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
            out.writeOptionalString(this.origin);
        }
    }

    public IndicesOptions indicesOptions() {
        return INDICES_OPTIONS;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("actions");
        for (AliasActions action : this.allAliasActions) {
            action.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static IndicesAliasesRequest fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObjectArray((request, actions) -> {
            for (AliasActions action : actions) {
                request.addAliasAction(action);
            }
        }, AliasActions.PARSER, new ParseField("actions", new String[0]));
    }

    public static class AliasActions
    implements AliasesRequest,
    Writeable,
    ToXContentObject {
        private static final ParseField INDEX = new ParseField("index", new String[0]);
        private static final ParseField INDICES = new ParseField("indices", new String[0]);
        private static final ParseField ALIAS = new ParseField("alias", new String[0]);
        private static final ParseField ALIASES = new ParseField("aliases", new String[0]);
        private static final ParseField FILTER = new ParseField("filter", new String[0]);
        private static final ParseField ROUTING = new ParseField("routing", new String[0]);
        private static final ParseField INDEX_ROUTING = new ParseField("index_routing", "indexRouting", "index-routing");
        private static final ParseField SEARCH_ROUTING = new ParseField("search_routing", "searchRouting", "search-routing");
        private static final ParseField IS_WRITE_INDEX = new ParseField("is_write_index", new String[0]);
        private static final ParseField IS_HIDDEN = new ParseField("is_hidden", new String[0]);
        private static final ParseField MUST_EXIST = new ParseField("must_exist", new String[0]);
        private static final ParseField ADD = new ParseField("add", new String[0]);
        private static final ParseField REMOVE = new ParseField("remove", new String[0]);
        private static final ParseField REMOVE_INDEX = new ParseField("remove_index", new String[0]);
        private static final ObjectParser<AliasActions, Void> ADD_PARSER = AliasActions.parser(ADD.getPreferredName(), AliasActions::add);
        private static final ObjectParser<AliasActions, Void> REMOVE_PARSER;
        private static final ObjectParser<AliasActions, Void> REMOVE_INDEX_PARSER;
        public static final ConstructingObjectParser<AliasActions, Void> PARSER;
        private final Type type;
        private String[] indices;
        private String[] aliases = Strings.EMPTY_ARRAY;
        private String[] originalAliases = Strings.EMPTY_ARRAY;
        private String filter;
        private String routing;
        private String indexRouting;
        private String searchRouting;
        private Boolean writeIndex;
        private Boolean isHidden;
        private Boolean mustExist;

        public static AliasActions add() {
            return new AliasActions(Type.ADD);
        }

        public static AliasActions remove() {
            return new AliasActions(Type.REMOVE);
        }

        public static AliasActions removeIndex() {
            return new AliasActions(Type.REMOVE_INDEX);
        }

        private static ObjectParser<AliasActions, Void> parser(String name, Supplier<AliasActions> supplier) {
            ObjectParser<AliasActions, Void> parser = new ObjectParser<AliasActions, Void>(name, supplier);
            parser.declareString((action, index) -> {
                if (action.indices() != null) {
                    throw new IllegalArgumentException("Only one of [index] and [indices] is supported");
                }
                action.index((String)index);
            }, INDEX);
            parser.declareStringArray(ObjectParser.fromList(String.class, (action, indices) -> {
                if (action.indices() != null) {
                    throw new IllegalArgumentException("Only one of [index] and [indices] is supported");
                }
                action.indices((String)indices);
            }), INDICES);
            parser.declareString((action, alias) -> {
                if (action.aliases() != null && action.aliases().length != 0) {
                    throw new IllegalArgumentException("Only one of [alias] and [aliases] is supported");
                }
                action.alias((String)alias);
            }, ALIAS);
            parser.declareStringArray(ObjectParser.fromList(String.class, (action, aliases) -> {
                if (action.aliases() != null && action.aliases().length != 0) {
                    throw new IllegalArgumentException("Only one of [alias] and [aliases] is supported");
                }
                action.aliases((String)aliases);
            }), ALIASES);
            return parser;
        }

        public AliasActions(Type type) {
            this.type = type;
        }

        public AliasActions(StreamInput in) throws IOException {
            this.type = Type.fromValue(in.readByte());
            this.indices = in.readStringArray();
            this.aliases = in.readStringArray();
            this.filter = in.readOptionalString();
            this.routing = in.readOptionalString();
            this.searchRouting = in.readOptionalString();
            this.indexRouting = in.readOptionalString();
            if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
                this.writeIndex = in.readOptionalBoolean();
            }
            if (in.getVersion().onOrAfter(Version.V_7_7_0)) {
                this.isHidden = in.readOptionalBoolean();
            }
            if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
                this.originalAliases = in.readStringArray();
            }
            this.mustExist = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readOptionalBoolean() : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.type.value());
            out.writeStringArray(this.indices);
            out.writeStringArray(this.aliases);
            out.writeOptionalString(this.filter);
            out.writeOptionalString(this.routing);
            out.writeOptionalString(this.searchRouting);
            out.writeOptionalString(this.indexRouting);
            if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                out.writeOptionalBoolean(this.writeIndex);
            }
            if (out.getVersion().onOrAfter(Version.V_7_7_0)) {
                out.writeOptionalBoolean(this.isHidden);
            }
            if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
                out.writeStringArray(this.originalAliases);
            }
            if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
                out.writeOptionalBoolean(this.mustExist);
            }
        }

        void validate() {
            if (this.indices == null) {
                throw new IllegalArgumentException("One of [index] or [indices] is required");
            }
            if (this.type != Type.REMOVE_INDEX && (this.aliases == null || this.aliases.length == 0)) {
                throw new IllegalArgumentException("One of [alias] or [aliases] is required");
            }
        }

        public Type actionType() {
            return this.type;
        }

        @Override
        public AliasActions indices(String ... indices) {
            if (indices == null || indices.length == 0) {
                throw new IllegalArgumentException("[indices] can't be empty");
            }
            for (String index : indices) {
                if (Strings.hasLength(index)) continue;
                throw new IllegalArgumentException("[indices] can't contain empty string");
            }
            this.indices = indices;
            return this;
        }

        public AliasActions index(String index) {
            if (!Strings.hasLength(index)) {
                throw new IllegalArgumentException("[index] can't be empty string");
            }
            this.indices = new String[]{index};
            return this;
        }

        public AliasActions aliases(String ... aliases) {
            if (this.type == Type.REMOVE_INDEX) {
                throw new IllegalArgumentException("[aliases] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            if (aliases == null || aliases.length == 0) {
                throw new IllegalArgumentException("[aliases] can't be empty");
            }
            for (String alias : aliases) {
                if (Strings.hasLength(alias)) continue;
                throw new IllegalArgumentException("[aliases] can't contain empty string");
            }
            this.aliases = aliases;
            this.originalAliases = aliases;
            return this;
        }

        public AliasActions alias(String alias) {
            if (this.type == Type.REMOVE_INDEX) {
                throw new IllegalArgumentException("[alias] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            if (!Strings.hasLength(alias)) {
                throw new IllegalArgumentException("[alias] can't be empty string");
            }
            this.aliases = new String[]{alias};
            this.originalAliases = this.aliases;
            return this;
        }

        public AliasActions routing(String routing) {
            if (this.type != Type.ADD) {
                throw new IllegalArgumentException("[routing] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.routing = routing;
            return this;
        }

        public String searchRouting() {
            return this.searchRouting == null ? this.routing : this.searchRouting;
        }

        public AliasActions searchRouting(String searchRouting) {
            if (this.type != Type.ADD) {
                throw new IllegalArgumentException("[search_routing] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.searchRouting = searchRouting;
            return this;
        }

        public String indexRouting() {
            return this.indexRouting == null ? this.routing : this.indexRouting;
        }

        public AliasActions indexRouting(String indexRouting) {
            if (this.type != Type.ADD) {
                throw new IllegalArgumentException("[index_routing] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.indexRouting = indexRouting;
            return this;
        }

        public String filter() {
            return this.filter;
        }

        public AliasActions filter(String filter) {
            if (this.type != Type.ADD) {
                throw new IllegalArgumentException("[filter] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.filter = filter;
            return this;
        }

        public AliasActions filter(Map<String, Object> filter) {
            if (filter == null || filter.isEmpty()) {
                this.filter = null;
                return this;
            }
            try {
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
                builder.map(filter);
                this.filter = Strings.toString(builder);
                return this;
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("Failed to generate [" + filter + "]", e);
            }
        }

        public AliasActions filter(QueryBuilder filter) {
            if (filter == null) {
                this.filter = null;
                return this;
            }
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                filter.toXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.close();
                this.filter = Strings.toString(builder);
                return this;
            }
            catch (IOException e) {
                throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
            }
        }

        public AliasActions writeIndex(Boolean writeIndex) {
            if (this.type != Type.ADD) {
                throw new IllegalArgumentException("[is_write_index] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.writeIndex = writeIndex;
            return this;
        }

        public Boolean writeIndex() {
            return this.writeIndex;
        }

        public AliasActions isHidden(Boolean isHidden) {
            if (this.type != Type.ADD) {
                throw new IllegalArgumentException("[" + IS_HIDDEN.getPreferredName() + "] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.isHidden = isHidden;
            return this;
        }

        public Boolean isHidden() {
            return this.isHidden;
        }

        public AliasActions mustExist(Boolean mustExist) {
            if (this.type != Type.REMOVE) {
                throw new IllegalArgumentException("[" + MUST_EXIST.getPreferredName() + "] is unsupported for [" + (Object)((Object)this.type) + "]");
            }
            this.mustExist = mustExist;
            return this;
        }

        public Boolean mustExist() {
            return this.mustExist;
        }

        @Override
        public String[] aliases() {
            return this.aliases;
        }

        @Override
        public void replaceAliases(String ... aliases) {
            this.aliases = aliases;
        }

        @Override
        public String[] getOriginalAliases() {
            return this.originalAliases;
        }

        @Override
        public boolean expandAliasesWildcards() {
            return this.type == Type.REMOVE;
        }

        @Override
        public String[] indices() {
            return this.indices;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startObject(this.type.fieldName);
            if (null != this.indices && 0 != this.indices.length) {
                builder.array(INDICES.getPreferredName(), this.indices);
            }
            if (0 != this.aliases.length) {
                builder.array(ALIASES.getPreferredName(), this.aliases);
            }
            if (!Strings.isEmpty(this.filter)) {
                try (StreamInput stream = new BytesArray(this.filter).streamInput();){
                    builder.rawField(FILTER.getPreferredName(), stream, XContentType.JSON);
                }
            }
            if (!Strings.isEmpty(this.routing)) {
                builder.field(ROUTING.getPreferredName(), this.routing);
            }
            if (!Strings.isEmpty(this.indexRouting)) {
                builder.field(INDEX_ROUTING.getPreferredName(), this.indexRouting);
            }
            if (!Strings.isEmpty(this.searchRouting)) {
                builder.field(SEARCH_ROUTING.getPreferredName(), this.searchRouting);
            }
            if (null != this.writeIndex) {
                builder.field(IS_WRITE_INDEX.getPreferredName(), this.writeIndex);
            }
            if (null != this.isHidden) {
                builder.field(IS_HIDDEN.getPreferredName(), this.isHidden);
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public static AliasActions fromXContent(XContentParser parser) throws IOException {
            return PARSER.apply(parser, null);
        }

        public String toString() {
            return "AliasActions[type=" + (Object)((Object)this.type) + ",indices=" + Arrays.toString(this.indices) + ",aliases=" + Arrays.deepToString(this.aliases) + ",filter=" + this.filter + ",routing=" + this.routing + ",indexRouting=" + this.indexRouting + ",searchRouting=" + this.searchRouting + ",writeIndex=" + this.writeIndex + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            AliasActions other = (AliasActions)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && Arrays.equals(this.indices, other.indices) && Arrays.equals(this.aliases, other.aliases) && Objects.equals(this.filter, other.filter) && Objects.equals(this.routing, other.routing) && Objects.equals(this.indexRouting, other.indexRouting) && Objects.equals(this.searchRouting, other.searchRouting) && Objects.equals(this.writeIndex, other.writeIndex) && Objects.equals(this.isHidden, other.isHidden);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.indices, this.aliases, this.filter, this.routing, this.indexRouting, this.searchRouting, this.writeIndex, this.isHidden});
        }

        static /* synthetic */ ParseField access$000() {
            return ADD;
        }

        static /* synthetic */ ParseField access$100() {
            return REMOVE;
        }

        static /* synthetic */ ParseField access$200() {
            return REMOVE_INDEX;
        }

        static {
            ADD_PARSER.declareObject(AliasActions::filter, (parser, m) -> {
                try {
                    return parser.mapOrdered();
                }
                catch (IOException e) {
                    throw new ParsingException(parser.getTokenLocation(), "Problems parsing [filter]", e, new Object[0]);
                }
            }, FILTER);
            ADD_PARSER.declareField(AliasActions::routing, XContentParser::text, ROUTING, ObjectParser.ValueType.INT);
            ADD_PARSER.declareField(AliasActions::indexRouting, XContentParser::text, INDEX_ROUTING, ObjectParser.ValueType.INT);
            ADD_PARSER.declareField(AliasActions::searchRouting, XContentParser::text, SEARCH_ROUTING, ObjectParser.ValueType.INT);
            ADD_PARSER.declareField(AliasActions::writeIndex, XContentParser::booleanValue, IS_WRITE_INDEX, ObjectParser.ValueType.BOOLEAN);
            ADD_PARSER.declareField(AliasActions::isHidden, XContentParser::booleanValue, IS_HIDDEN, ObjectParser.ValueType.BOOLEAN);
            ADD_PARSER.declareField(AliasActions::mustExist, XContentParser::booleanValue, MUST_EXIST, ObjectParser.ValueType.BOOLEAN);
            REMOVE_PARSER = AliasActions.parser(REMOVE.getPreferredName(), AliasActions::remove);
            REMOVE_INDEX_PARSER = AliasActions.parser(REMOVE_INDEX.getPreferredName(), AliasActions::removeIndex);
            PARSER = new ConstructingObjectParser("alias_action", a -> {
                AliasActions action = null;
                for (Object o : a) {
                    if (o == null) continue;
                    if (action == null) {
                        action = (AliasActions)o;
                        continue;
                    }
                    throw new IllegalArgumentException("Too many operations declared on operation entry");
                }
                return action;
            });
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), ADD_PARSER, ADD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), REMOVE_PARSER, REMOVE);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), REMOVE_INDEX_PARSER, REMOVE_INDEX);
        }

        public static enum Type {
            ADD(0, AliasActions.access$000()),
            REMOVE(1, AliasActions.access$100()),
            REMOVE_INDEX(2, AliasActions.access$200());

            private final byte value;
            private final String fieldName;

            private Type(byte value, ParseField field) {
                this.value = value;
                this.fieldName = field.getPreferredName();
            }

            public byte value() {
                return this.value;
            }

            public static Type fromValue(byte value) {
                switch (value) {
                    case 0: {
                        return ADD;
                    }
                    case 1: {
                        return REMOVE;
                    }
                    case 2: {
                        return REMOVE_INDEX;
                    }
                }
                throw new IllegalArgumentException("No type for action [" + value + "]");
            }
        }
    }
}

